/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.googlecode.jsonrpc4j.ExceptionResolver;
import com.googlecode.jsonrpc4j.JsonRpcClientException;
import com.googlecode.jsonrpc4j.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExceptionResolver
implements ExceptionResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionResolver.class);
    public static final DefaultExceptionResolver INSTANCE = new DefaultExceptionResolver();

    @Override
    public Throwable resolveException(ObjectNode response) {
        ObjectNode errorObject = (ObjectNode)ObjectNode.class.cast(response.get("error"));
        if (!Util.hasNonNullObjectData(errorObject, "data")) {
            return this.createJsonRpcClientException(errorObject);
        }
        ObjectNode dataObject = (ObjectNode)ObjectNode.class.cast(errorObject.get("data"));
        if (!Util.hasNonNullTextualData(dataObject, "exceptionTypeName")) {
            return this.createJsonRpcClientException(errorObject);
        }
        try {
            String exceptionTypeName = dataObject.get("exceptionTypeName").asText();
            String message = Util.hasNonNullTextualData(dataObject, "message") ? dataObject.get("message").asText() : null;
            return this.createThrowable(exceptionTypeName, message);
        }
        catch (Exception e) {
            logger.warn("Unable to create throwable", e);
            return this.createJsonRpcClientException(errorObject);
        }
    }

    private JsonRpcClientException createJsonRpcClientException(ObjectNode errorObject) {
        int code = errorObject.has("code") ? errorObject.get("code").asInt() : 0;
        return new JsonRpcClientException(code, errorObject.get("message").asText(), errorObject.get("data"));
    }

    private Throwable createThrowable(String typeName, String message) throws IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Class<? extends Throwable> clazz = this.resolveThrowableClass(typeName);
        Constructor<? extends Throwable> defaultCtr = this.getDefaultConstructor(clazz);
        Constructor<? extends Throwable> messageCtr = this.getMessageConstructor(clazz);
        if (message != null && messageCtr != null) {
            return messageCtr.newInstance(message);
        }
        if (message != null && defaultCtr != null) {
            logger.warn("Unable to invoke message constructor for {}, fallback to default", (Object)clazz.getName());
            return defaultCtr.newInstance(new Object[0]);
        }
        if (message == null && defaultCtr != null) {
            return defaultCtr.newInstance(new Object[0]);
        }
        if (message == null && messageCtr != null) {
            logger.warn("Passing null message to message constructor for {}", (Object)clazz.getName());
            return messageCtr.newInstance(new Object[]{null});
        }
        logger.error("Unable to find message or default constructor for {} have {}", (Object)clazz.getName(), (Object)clazz.getDeclaredConstructors());
        return null;
    }

    protected Class<? extends Throwable> resolveThrowableClass(String typeName) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(typeName);
            if (Throwable.class.isAssignableFrom(clazz)) {
                return clazz.asSubclass(Throwable.class);
            }
            logger.warn("Type does not inherit from Throwable {}", (Object)clazz.getName());
        }
        catch (ClassNotFoundException e) {
            logger.warn("Unable to load Throwable class {}", (Object)typeName);
            throw e;
        }
        catch (Exception e) {
            logger.warn("Unable to load Throwable class {}", (Object)typeName);
        }
        return null;
    }

    private Constructor<? extends Throwable> getDefaultConstructor(Class<? extends Throwable> clazz) {
        Constructor<? extends Throwable> defaultCtr = null;
        try {
            defaultCtr = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            this.handleException(e);
        }
        return defaultCtr;
    }

    private Constructor<? extends Throwable> getMessageConstructor(Class<? extends Throwable> clazz) {
        Constructor<? extends Throwable> messageCtr = null;
        try {
            messageCtr = clazz.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            this.handleException(e);
        }
        return messageCtr;
    }

    private void handleException(Exception e) {
    }
}

