/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.DefaultHttpStatusCodeProvider;
import com.googlecode.jsonrpc4j.ErrorResolver;
import com.googlecode.jsonrpc4j.JsonRpcBasicServer;
import com.googlecode.jsonrpc4j.StreamEndedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcServer
extends JsonRpcBasicServer {
    private static final Logger logger = LoggerFactory.getLogger(JsonRpcServer.class);
    private static final String GZIP = "gzip";
    private String contentType = "application/json-rpc";

    public JsonRpcServer(ObjectMapper mapper, Object handler, Class<?> remoteInterface) {
        super(mapper, handler, remoteInterface);
    }

    public JsonRpcServer(ObjectMapper mapper, Object handler) {
        super(mapper, handler, null);
    }

    public JsonRpcServer(Object handler, Class<?> remoteInterface) {
        super(new ObjectMapper(), handler, remoteInterface);
    }

    public JsonRpcServer(Object handler) {
        super(new ObjectMapper(), handler, null);
    }

    public void handle(ResourceRequest request, ResourceResponse response) throws IOException {
        logger.debug("Handing ResourceRequest {}", (Object)request.getMethod());
        response.setContentType(this.contentType);
        InputStream input = this.getRequestStream(request);
        OutputStream output = response.getPortletOutputStream();
        this.handleRequest(input, output);
        output.flush();
    }

    private InputStream getRequestStream(ResourceRequest request) throws IOException {
        if (request.getMethod().equals("POST")) {
            return request.getPortletInputStream();
        }
        if (request.getMethod().equals("GET")) {
            return JsonRpcServer.createInputStream(request);
        }
        throw new IOException("Invalid request method, only POST and GET is supported");
    }

    private static InputStream createInputStream(ResourceRequest request) throws IOException {
        return JsonRpcServer.createInputStream(request.getParameter("method"), request.getParameter("id"), request.getParameter("params"));
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug("Handling HttpServletRequest {}", (Object)request);
        response.setContentType(this.contentType);
        ServletOutputStream output = response.getOutputStream();
        InputStream input = this.getRequestStream(request);
        int result = ErrorResolver.JsonError.PARSE_ERROR.code;
        int contentLength = 0;
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try {
            String acceptEncoding = request.getHeader("Accept-Encoding");
            result = this.handleRequest0(input, (OutputStream)output, acceptEncoding, response, byteOutput);
            contentLength = byteOutput.size();
        }
        catch (Throwable t2) {
            if (StreamEndedException.class.isInstance(t2)) {
                logger.debug("Bad request: empty contents!");
            }
            logger.error(t2.getMessage(), t2);
        }
        int httpStatusCode = this.httpStatusCodeProvider == null ? DefaultHttpStatusCodeProvider.INSTANCE.getHttpStatusCode(result) : this.httpStatusCodeProvider.getHttpStatusCode(result);
        response.setStatus(httpStatusCode);
        response.setContentLength(contentLength);
        byteOutput.writeTo((OutputStream)output);
        output.flush();
    }

    private InputStream getRequestStream(HttpServletRequest request) throws IOException {
        Object input;
        if (request.getMethod().equals("POST")) {
            input = request.getInputStream();
        } else if (request.getMethod().equals("GET")) {
            input = JsonRpcServer.createInputStream(request);
        } else {
            throw new IOException("Invalid request method, only POST and GET is supported");
        }
        return input;
    }

    private int handleRequest0(InputStream input, OutputStream output, String contentEncoding, HttpServletResponse response, ByteArrayOutputStream byteOutput) throws IOException {
        return this.handleRequest(input, byteOutput);
    }

    private static InputStream createInputStream(HttpServletRequest request) throws IOException {
        String method = request.getParameter("method");
        String id = request.getParameter("id");
        String params = request.getParameter("params");
        if (method == null && id == null && params == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return JsonRpcServer.createInputStream(method, id, params);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

