/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonrpc4j.ErrorResolver;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MultipleErrorResolver
implements ErrorResolver {
    private final List<ErrorResolver> resolvers = new LinkedList<ErrorResolver>();

    public MultipleErrorResolver(ErrorResolver ... resolvers) {
        Collections.addAll(this.resolvers, resolvers);
    }

    public void addErrorResolver(ErrorResolver errorResolver) {
        this.resolvers.add(errorResolver);
    }

    @Override
    public ErrorResolver.JsonError resolveError(Throwable t2, Method method, List<JsonNode> arguments) {
        for (ErrorResolver resolver : this.resolvers) {
            ErrorResolver.JsonError resolvedError = resolver.resolveError(t2, method, arguments);
            if (resolvedError == null) continue;
            return resolvedError;
        }
        return null;
    }
}

