/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonrpc4j.InvocationListener;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MultipleInvocationListener
implements InvocationListener {
    private final List<InvocationListener> invocationListeners = new LinkedList<InvocationListener>();

    public MultipleInvocationListener(InvocationListener ... invocationListeners) {
        Collections.addAll(this.invocationListeners, invocationListeners);
    }

    public void addInvocationListener(InvocationListener invocationListener) {
        this.invocationListeners.add(invocationListener);
    }

    @Override
    public void willInvoke(Method method, List<JsonNode> arguments) {
        for (InvocationListener invocationListener : this.invocationListeners) {
            invocationListener.willInvoke(method, arguments);
        }
    }

    @Override
    public void didInvoke(Method method, List<JsonNode> arguments, Object result, Throwable t2, long duration) {
        for (InvocationListener invocationListener : this.invocationListeners) {
            invocationListener.didInvoke(method, arguments, result, t2, duration);
        }
    }
}

