/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.googlecode.jsonrpc4j.IJsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcMethod;
import com.googlecode.jsonrpc4j.ReflectionUtil;
import com.googlecode.jsonrpc4j.spring.rest.JsonRpcRestClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProxyUtil {
    private static final Logger logger = LoggerFactory.getLogger(ProxyUtil.class);

    public static Object createCompositeServiceProxy(ClassLoader classLoader, Object[] services, boolean allowMultipleInheritance) {
        return ProxyUtil.createCompositeServiceProxy(classLoader, services, null, allowMultipleInheritance);
    }

    public static Object createCompositeServiceProxy(ClassLoader classLoader, Object[] services, Class<?>[] serviceInterfaces, boolean allowMultipleInheritance) {
        Set<Class<?>> interfaces = ProxyUtil.collectInterfaces(services, serviceInterfaces);
        final Map<Class<?>, Object> serviceClassToInstanceMapping = ProxyUtil.buildServiceMap(services, allowMultipleInheritance, interfaces);
        return Proxy.newProxyInstance(classLoader, interfaces.toArray(new Class[0]), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
                Class<?> clazz = method.getDeclaringClass();
                if (clazz == Object.class) {
                    return ProxyUtil.proxyObjectMethods(method, proxy, args2);
                }
                return method.invoke(serviceClassToInstanceMapping.get(clazz), args2);
            }
        });
    }

    private static Set<Class<?>> collectInterfaces(Object[] services, Class<?>[] serviceInterfaces) {
        HashSet interfaces = new HashSet();
        if (serviceInterfaces != null) {
            interfaces.addAll(Arrays.asList(serviceInterfaces));
        } else {
            for (Object o : services) {
                interfaces.addAll(Arrays.asList(o.getClass().getInterfaces()));
            }
        }
        return interfaces;
    }

    private static Map<Class<?>, Object> buildServiceMap(Object[] services, boolean allowMultipleInheritance, Set<Class<?>> interfaces) {
        HashMap serviceMap = new HashMap();
        for (Class<?> clazz : interfaces) {
            if (serviceMap.containsKey(clazz) && allowMultipleInheritance) continue;
            if (serviceMap.containsKey(clazz)) {
                throw new IllegalArgumentException("Multiple inheritance not allowed " + clazz.getName());
            }
            for (Object o : services) {
                if (!clazz.isInstance(o)) continue;
                logger.debug("Using {} for {}", (Object)o.getClass().getName(), (Object)clazz.getName());
                serviceMap.put(clazz, o);
                break;
            }
            if (serviceMap.containsKey(clazz)) continue;
            throw new IllegalArgumentException("None of the provided services implement " + clazz.getName());
        }
        return serviceMap;
    }

    private static Object proxyObjectMethods(Method method, Object proxyObject, Object[] args2) {
        String name = method.getName();
        if (name.equals("toString")) {
            return proxyObject.getClass().getName() + "@" + System.identityHashCode(proxyObject);
        }
        if (name.equals("hashCode")) {
            return System.identityHashCode(proxyObject);
        }
        if (name.equals("equals")) {
            return proxyObject == args2[0];
        }
        throw new RuntimeException(method.getName() + " is not a member of java.lang.Object");
    }

    public static <T> T createClientProxy(ClassLoader classLoader, Class<T> proxyInterface, JsonRpcClient client, Socket socket) throws IOException {
        return ProxyUtil.createClientProxy(classLoader, proxyInterface, client, socket.getInputStream(), socket.getOutputStream());
    }

    public static <T> T createClientProxy(ClassLoader classLoader, Class<T> proxyInterface, final JsonRpcClient client, final InputStream input, final OutputStream output) {
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{proxyInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
                if (ProxyUtil.isDeclaringClassAnObject(method)) {
                    return ProxyUtil.proxyObjectMethods(method, proxy, args2);
                }
                Object arguments = ReflectionUtil.parseArguments(method, args2);
                String methodName = ProxyUtil.getMethodName(method);
                return client.invokeAndReadResponse(methodName, arguments, method.getGenericReturnType(), output, input);
            }
        });
    }

    private static boolean isDeclaringClassAnObject(Method method) {
        return method.getDeclaringClass() == Object.class;
    }

    public static String getMethodName(Method method) {
        JsonRpcMethod jsonRpcMethod = ReflectionUtil.getAnnotation(method, JsonRpcMethod.class);
        if (jsonRpcMethod == null) {
            return method.getName();
        }
        return jsonRpcMethod.value();
    }

    public static <T> T createClientProxy(Class<T> clazz, JsonRpcRestClient client) {
        return ProxyUtil.createClientProxy(clazz.getClassLoader(), clazz, client);
    }

    public static <T> T createClientProxy(ClassLoader classLoader, Class<T> proxyInterface, IJsonRpcClient client) {
        return ProxyUtil.createClientProxy(classLoader, proxyInterface, client, new HashMap<String, String>());
    }

    private static <T> T createClientProxy(ClassLoader classLoader, Class<T> proxyInterface, final IJsonRpcClient client, final Map<String, String> extraHeaders) {
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{proxyInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
                if (ProxyUtil.isDeclaringClassAnObject(method)) {
                    return ProxyUtil.proxyObjectMethods(method, proxy, args2);
                }
                Object arguments = ReflectionUtil.parseArguments(method, args2);
                String methodName = ProxyUtil.getMethodName(method);
                return client.invoke(methodName, arguments, method.getGenericReturnType(), (Map<String, String>)extraHeaders);
            }
        });
    }
}

