/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.ConvertedParameterTransformer;
import com.googlecode.jsonrpc4j.ErrorResolver;
import com.googlecode.jsonrpc4j.HttpStatusCodeProvider;
import com.googlecode.jsonrpc4j.InvocationListener;
import com.googlecode.jsonrpc4j.JsonRpcServer;
import com.googlecode.jsonrpc4j.ProxyUtil;
import com.googlecode.jsonrpc4j.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

abstract class AbstractCompositeJsonServiceExporter
implements InitializingBean,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCompositeJsonServiceExporter.class);
    private ObjectMapper objectMapper;
    private ApplicationContext applicationContext;
    private ErrorResolver errorResolver = null;
    private boolean backwardsCompatible = true;
    private boolean rethrowExceptions = false;
    private boolean allowExtraParams = false;
    private boolean allowLessParams = false;
    private boolean shouldLogInvocationErrors = true;
    private InvocationListener invocationListener = null;
    private HttpStatusCodeProvider httpStatusCodeProvider = null;
    private ConvertedParameterTransformer convertedParameterTransformer = null;
    private String contentType = null;
    private JsonRpcServer jsonRpcServer;
    private boolean allowMultipleInheritance = false;
    private Class<?>[] serviceInterfaces = null;
    private Object[] services = new Object[0];

    AbstractCompositeJsonServiceExporter() {
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.objectMapper == null && this.applicationContext != null && this.applicationContext.containsBean("objectMapper")) {
            this.objectMapper = (ObjectMapper)this.applicationContext.getBean("objectMapper");
        }
        if (this.objectMapper == null && this.applicationContext != null) {
            try {
                this.objectMapper = (ObjectMapper)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ObjectMapper.class);
            }
            catch (Exception e) {
                logger.error("Could not load ObjectMapper from ApplicationContext", e);
            }
        }
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        Object service = ProxyUtil.createCompositeServiceProxy(this.getClass().getClassLoader(), this.services, this.serviceInterfaces, this.allowMultipleInheritance);
        this.jsonRpcServer = new JsonRpcServer(this.objectMapper, service);
        this.jsonRpcServer.setErrorResolver(this.errorResolver);
        this.jsonRpcServer.setBackwardsCompatible(this.backwardsCompatible);
        this.jsonRpcServer.setRethrowExceptions(this.rethrowExceptions);
        this.jsonRpcServer.setAllowExtraParams(this.allowExtraParams);
        this.jsonRpcServer.setAllowLessParams(this.allowLessParams);
        this.jsonRpcServer.setInvocationListener(this.invocationListener);
        this.jsonRpcServer.setHttpStatusCodeProvider(this.httpStatusCodeProvider);
        this.jsonRpcServer.setConvertedParameterTransformer(this.convertedParameterTransformer);
        this.jsonRpcServer.setShouldLogInvocationErrors(this.shouldLogInvocationErrors);
        if (this.contentType != null) {
            this.jsonRpcServer.setContentType(this.contentType);
        }
        ReflectionUtil.clearCache();
        this.exportService();
    }

    void exportService() throws Exception {
    }

    JsonRpcServer getJsonRpcServer() {
        return this.jsonRpcServer;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setErrorResolver(ErrorResolver errorResolver) {
        this.errorResolver = errorResolver;
    }

    public void setBackwardsCompatible(boolean backwardsCompatible) {
        this.backwardsCompatible = backwardsCompatible;
    }

    public void setRethrowExceptions(boolean rethrowExceptions) {
        this.rethrowExceptions = rethrowExceptions;
    }

    public void setAllowExtraParams(boolean allowExtraParams) {
        this.allowExtraParams = allowExtraParams;
    }

    public void setAllowLessParams(boolean allowLessParams) {
        this.allowLessParams = allowLessParams;
    }

    public void setInvocationListener(InvocationListener invocationListener) {
        this.invocationListener = invocationListener;
    }

    public void setHttpStatusCodeProvider(HttpStatusCodeProvider httpStatusCodeProvider) {
        this.httpStatusCodeProvider = httpStatusCodeProvider;
    }

    public void setConvertedParameterTransformer(ConvertedParameterTransformer convertedParameterTransformer) {
        this.convertedParameterTransformer = convertedParameterTransformer;
    }

    public void setShouldLogInvocationErrors(boolean shouldLogInvocationErrors) {
        this.shouldLogInvocationErrors = shouldLogInvocationErrors;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setAllowMultipleInheritance(boolean allowMultipleInheritance) {
        this.allowMultipleInheritance = allowMultipleInheritance;
    }

    public void setServiceInterfaces(Class<?>[] serviceInterfaces) {
        this.serviceInterfaces = serviceInterfaces;
    }

    public void setServices(Object[] services) {
        this.services = services;
    }
}

