/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.ConvertedParameterTransformer;
import com.googlecode.jsonrpc4j.ErrorResolver;
import com.googlecode.jsonrpc4j.HttpStatusCodeProvider;
import com.googlecode.jsonrpc4j.InvocationListener;
import com.googlecode.jsonrpc4j.JsonRpcService;
import com.googlecode.jsonrpc4j.spring.JsonServiceExporter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.util.ClassUtils;

@Deprecated
public class AutoJsonRpcServiceExporter
implements BeanFactoryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AutoJsonRpcServiceExporter.class);
    private static final String PATH_PREFIX = "/";
    private ObjectMapper objectMapper;
    private ErrorResolver errorResolver = null;
    private Boolean registerTraceInterceptor;
    private boolean backwardsCompatible = true;
    private boolean rethrowExceptions = false;
    private boolean allowExtraParams = false;
    private boolean allowLessParams = false;
    private InvocationListener invocationListener = null;
    private HttpStatusCodeProvider httpStatusCodeProvider = null;
    private ConvertedParameterTransformer convertedParameterTransformer = null;

    private static Map<String, String> findServiceBeanDefinitions(ConfigurableListableBeanFactory beanFactory) {
        HashMap<String, String> serviceBeanNames = new HashMap<String, String>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            JsonRpcService jsonRpcPath = (JsonRpcService)beanFactory.findAnnotationOnBean(beanName, JsonRpcService.class);
            if (!AutoJsonRpcServiceExporter.hasServiceAnnotation(jsonRpcPath)) continue;
            String pathValue = jsonRpcPath.value();
            logger.debug("Found JSON-RPC path '{}' for bean [{}].", (Object)pathValue, (Object)beanName);
            if (!AutoJsonRpcServiceExporter.isNotDuplicateService(serviceBeanNames, beanName, pathValue)) continue;
            serviceBeanNames.put(pathValue, beanName);
        }
        AutoJsonRpcServiceExporter.collectFromParentBeans(beanFactory, serviceBeanNames);
        return serviceBeanNames;
    }

    private static void collectFromParentBeans(ConfigurableListableBeanFactory beanFactory, Map<String, String> serviceBeanNames) {
        BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
        if (parentBeanFactory != null && ConfigurableListableBeanFactory.class.isInstance(parentBeanFactory)) {
            for (Map.Entry<String, String> entry : AutoJsonRpcServiceExporter.findServiceBeanDefinitions((ConfigurableListableBeanFactory)parentBeanFactory).entrySet()) {
                if (!AutoJsonRpcServiceExporter.isNotDuplicateService(serviceBeanNames, entry.getKey(), entry.getValue())) continue;
                serviceBeanNames.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private static boolean isNotDuplicateService(Map<String, String> serviceBeanNames, String beanName, String pathValue) {
        if (serviceBeanNames.containsKey(pathValue)) {
            String otherBeanName = serviceBeanNames.get(pathValue);
            logger.debug("Duplicate JSON-RPC path specification: found {} on both [{}] and [{}].", pathValue, beanName, otherBeanName);
            return false;
        }
        return true;
    }

    private static boolean hasServiceAnnotation(JsonRpcService jsonRpcPath) {
        return jsonRpcPath != null;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        Map<String, String> servicePathToBeanName = AutoJsonRpcServiceExporter.findServiceBeanDefinitions((ConfigurableListableBeanFactory)defaultListableBeanFactory);
        for (Map.Entry<String, String> entry : servicePathToBeanName.entrySet()) {
            this.registerServiceProxy(defaultListableBeanFactory, this.makeUrlPath(entry.getKey()), entry.getValue());
        }
    }

    private String makeUrlPath(String servicePath) {
        return PATH_PREFIX.concat(servicePath);
    }

    private void registerServiceProxy(DefaultListableBeanFactory defaultListableBeanFactory, String servicePath, String serviceBeanName) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(JsonServiceExporter.class).addPropertyReference("service", serviceBeanName);
        BeanDefinition serviceBeanDefinition = this.findBeanDefinition((ConfigurableListableBeanFactory)defaultListableBeanFactory, serviceBeanName);
        for (Class<?> currentInterface : this.getBeanInterfaces(serviceBeanDefinition, defaultListableBeanFactory.getBeanClassLoader())) {
            if (!currentInterface.isAnnotationPresent(JsonRpcService.class)) continue;
            String serviceInterface = currentInterface.getName();
            logger.debug("Registering interface '{}' for JSON-RPC bean [{}].", (Object)serviceInterface, (Object)serviceBeanName);
            builder.addPropertyValue("serviceInterface", (Object)serviceInterface);
            break;
        }
        if (this.objectMapper != null) {
            builder.addPropertyValue("objectMapper", (Object)this.objectMapper);
        }
        if (this.errorResolver != null) {
            builder.addPropertyValue("errorResolver", (Object)this.errorResolver);
        }
        if (this.invocationListener != null) {
            builder.addPropertyValue("invocationListener", (Object)this.invocationListener);
        }
        if (this.registerTraceInterceptor != null) {
            builder.addPropertyValue("registerTraceInterceptor", (Object)this.registerTraceInterceptor);
        }
        if (this.httpStatusCodeProvider != null) {
            builder.addPropertyValue("httpStatusCodeProvider", (Object)this.httpStatusCodeProvider);
        }
        if (this.convertedParameterTransformer != null) {
            builder.addPropertyValue("convertedParameterTransformer", (Object)this.convertedParameterTransformer);
        }
        builder.addPropertyValue("backwardsCompatible", (Object)this.backwardsCompatible);
        builder.addPropertyValue("rethrowExceptions", (Object)this.rethrowExceptions);
        builder.addPropertyValue("allowExtraParams", (Object)this.allowExtraParams);
        builder.addPropertyValue("allowLessParams", (Object)this.allowLessParams);
        defaultListableBeanFactory.registerBeanDefinition(servicePath, (BeanDefinition)builder.getBeanDefinition());
    }

    private BeanDefinition findBeanDefinition(ConfigurableListableBeanFactory beanFactory, String serviceBeanName) {
        if (beanFactory.containsLocalBean(serviceBeanName)) {
            return beanFactory.getBeanDefinition(serviceBeanName);
        }
        BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
        if (parentBeanFactory != null && ConfigurableListableBeanFactory.class.isInstance(parentBeanFactory)) {
            return this.findBeanDefinition((ConfigurableListableBeanFactory)parentBeanFactory, serviceBeanName);
        }
        throw new RuntimeException(String.format("Bean with name '%s' can no longer be found.", serviceBeanName));
    }

    private Class<?>[] getBeanInterfaces(BeanDefinition serviceBeanDefinition, ClassLoader beanClassLoader) {
        String beanClassName = serviceBeanDefinition.getBeanClassName();
        try {
            Class beanClass = ClassUtils.forName((String)beanClassName, (ClassLoader)beanClassLoader);
            return ClassUtils.getAllInterfacesForClass((Class)beanClass, (ClassLoader)beanClassLoader);
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new RuntimeException(String.format("Cannot find bean class '%s'.", beanClassName), e);
        }
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setErrorResolver(ErrorResolver errorResolver) {
        this.errorResolver = errorResolver;
    }

    public void setBackwardsCompatible(boolean backwardsCompatible) {
        this.backwardsCompatible = backwardsCompatible;
    }

    public void setRethrowExceptions(boolean rethrowExceptions) {
        this.rethrowExceptions = rethrowExceptions;
    }

    public void setAllowExtraParams(boolean allowExtraParams) {
        this.allowExtraParams = allowExtraParams;
    }

    public void setAllowLessParams(boolean allowLessParams) {
        this.allowLessParams = allowLessParams;
    }

    public void setRegisterTraceInterceptor(boolean registerTraceInterceptor) {
        this.registerTraceInterceptor = registerTraceInterceptor;
    }

    public void setInvocationListener(InvocationListener invocationListener) {
        this.invocationListener = invocationListener;
    }

    public void setHttpStatusCodeProvider(HttpStatusCodeProvider httpStatusCodeProvider) {
        this.httpStatusCodeProvider = httpStatusCodeProvider;
    }

    public void setConvertedParameterTransformer(ConvertedParameterTransformer convertedParameterTransformer) {
        this.convertedParameterTransformer = convertedParameterTransformer;
    }
}

