/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring;

import com.googlecode.jsonrpc4j.StreamServer;
import com.googlecode.jsonrpc4j.spring.AbstractJsonServiceExporter;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import org.springframework.beans.factory.DisposableBean;

public class JsonStreamServiceExporter
extends AbstractJsonServiceExporter
implements DisposableBean {
    private static final int DEFAULT_MAX_THREADS = 50;
    private static final int DEFAULT_PORT = 10420;
    private static final int DEFAULT_BACKLOG = 0;
    private static final int DEFAULT_MAX_CLIENT_ERRORS = 5;
    private ServerSocketFactory serverSocketFactory;
    private int maxThreads = 50;
    private int port = 10420;
    private int backlog = 0;
    private int maxClientErrors = 5;
    private String hostName = "0.0.0.0";
    private StreamServer streamServer;

    @Override
    protected void exportService() throws Exception {
        if (this.streamServer == null) {
            if (this.serverSocketFactory == null) {
                this.serverSocketFactory = ServerSocketFactory.getDefault();
            }
            ServerSocket serverSocket = this.serverSocketFactory.createServerSocket(this.port, this.backlog, InetAddress.getByName(this.hostName));
            this.streamServer = new StreamServer(this.getJsonRpcServer(), this.maxThreads, serverSocket);
            this.streamServer.setMaxClientErrors(this.maxClientErrors);
        }
        this.streamServer.start();
    }

    public void destroy() throws Exception {
        this.streamServer.stop();
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setStreamServer(StreamServer streamServer) {
        this.streamServer = streamServer;
    }

    public void setMaxClientErrors(int maxClientErrors) {
        this.maxClientErrors = maxClientErrors;
    }
}

