/*
 * Decompiled with CFR 0.152.
 */
package com.runjva.sourceforge.jsocks.protocol;

import com.runjva.sourceforge.jsocks.protocol.InetRange;
import java.net.InetAddress;
import java.net.UnknownHostException;

class InetRangeResolver
implements Runnable {
    Object[] entry;
    String from;
    String to;

    InetRangeResolver(Object[] entry) {
        this.entry = entry;
        this.from = null;
        this.to = null;
    }

    InetRangeResolver(Object[] entry, String from, String to) {
        this.entry = entry;
        this.from = from;
        this.to = to;
    }

    public final void resolve() {
        this.resolve(true);
    }

    public final void resolve(boolean inSeparateThread) {
        if (inSeparateThread) {
            Thread t2 = new Thread(this);
            t2.start();
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        try {
            if (this.from == null) {
                InetAddress ip = InetAddress.getByName((String)this.entry[0]);
                this.entry[1] = ip;
                Long l = new Long(InetRange.ip2long(ip));
                this.entry[2] = l;
                this.entry[3] = l;
            } else {
                InetAddress f = InetAddress.getByName(this.from);
                InetAddress t2 = InetAddress.getByName(this.to);
                this.entry[2] = new Long(InetRange.ip2long(f));
                this.entry[3] = new Long(InetRange.ip2long(t2));
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

