/*
 * Decompiled with CFR 0.152.
 */
package com.runjva.sourceforge.jsocks.protocol;

import com.runjva.sourceforge.jsocks.protocol.ProxyMessage;
import com.runjva.sourceforge.jsocks.protocol.Socks4Message;
import com.runjva.sourceforge.jsocks.protocol.Socks5Message;
import com.runjva.sourceforge.jsocks.protocol.SocksException;
import com.runjva.sourceforge.jsocks.protocol.SocksProxyBase;
import com.runjva.sourceforge.jsocks.protocol.SocksServerSocket;
import com.runjva.sourceforge.jsocks.protocol.SocksSocket;
import com.runjva.sourceforge.jsocks.protocol.UDPRelayServer;
import com.runjva.sourceforge.jsocks.server.ServerAuthenticator;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServer
implements Runnable {
    ServerAuthenticator auth;
    ProxyMessage msg = null;
    Socket sock = null;
    Socket remote_sock = null;
    ServerSocket ss = null;
    UDPRelayServer relayServer = null;
    InputStream in;
    InputStream remote_in;
    OutputStream out;
    OutputStream remote_out;
    int mode;
    static final int START_MODE = 0;
    static final int ACCEPT_MODE = 1;
    static final int PIPE_MODE = 2;
    static final int ABORT_MODE = 3;
    static final int BUF_SIZE = 8192;
    Thread pipe_thread1;
    Thread pipe_thread2;
    long lastReadTime;
    static int iddleTimeout = 180000;
    static int acceptTimeout = 180000;
    static Logger log = LoggerFactory.getLogger(ProxyServer.class);
    static SocksProxyBase proxy;
    static final String[] command_names;

    public ProxyServer(ServerAuthenticator auth) {
        this.auth = auth;
    }

    ProxyServer(ServerAuthenticator auth, Socket s2) {
        this.auth = auth;
        this.sock = s2;
        this.mode = 0;
    }

    public static void setProxy(SocksProxyBase p) {
        UDPRelayServer.proxy = proxy = p;
    }

    public static SocksProxyBase getProxy() {
        return proxy;
    }

    public static void setIddleTimeout(int timeout) {
        iddleTimeout = timeout;
    }

    public static void setAcceptTimeout(int timeout) {
        acceptTimeout = timeout;
    }

    public static void setUDPTimeout(int timeout) {
        UDPRelayServer.setTimeout(timeout);
    }

    public static void setDatagramSize(int size) {
        UDPRelayServer.setDatagramSize(size);
    }

    public void start(int port) {
        this.start(port, 5, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int port, int backlog, InetAddress localIP) {
        try {
            this.ss = new ServerSocket(port, backlog, localIP);
            String address = this.ss.getInetAddress().getHostAddress();
            int localPort = this.ss.getLocalPort();
            log.info("Starting SOCKS Proxy on: {}:{}", (Object)address, (Object)localPort);
            while (true) {
                Socket s2 = this.ss.accept();
                String hostName = s2.getInetAddress().getHostName();
                int port2 = s2.getPort();
                log.info("Accepted from:{}:{}", (Object)hostName, (Object)port2);
                ProxyServer ps = new ProxyServer(this.auth, s2);
                new Thread(ps).start();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void stop() {
        try {
            if (this.ss != null) {
                this.ss.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        switch (this.mode) {
            case 0: {
                try {
                    this.startSession();
                    break;
                }
                catch (IOException ioe) {
                    this.handleException(ioe);
                    break;
                }
                finally {
                    this.abort();
                    if (this.auth != null) {
                        this.auth.endSession();
                    }
                    log.info("Main thread(client->remote)stopped.");
                }
            }
            case 1: {
                try {
                    this.doAccept();
                    this.mode = 2;
                    this.pipe_thread1.interrupt();
                    this.pipe(this.remote_in, this.out);
                    break;
                }
                catch (IOException ioe) {
                    this.handleException(ioe);
                    break;
                }
                finally {
                    this.abort();
                    log.info("Accept thread(remote->client) stopped");
                }
            }
            case 2: {
                try {
                    this.pipe(this.remote_in, this.out);
                    break;
                }
                catch (IOException iOException) {
                    break;
                }
                finally {
                    this.abort();
                    log.info("Support thread(remote->client) stopped");
                }
            }
            case 3: {
                break;
            }
            default: {
                log.warn("Unexpected MODE " + this.mode);
            }
        }
    }

    private void startSession() throws IOException {
        this.sock.setSoTimeout(iddleTimeout);
        try {
            this.auth = this.auth.startSession(this.sock);
        }
        catch (IOException ioe) {
            log.warn("Auth throwed exception:", ioe);
            this.auth = null;
            return;
        }
        if (this.auth == null) {
            log.info("Authentication failed");
            return;
        }
        this.in = this.auth.getInputStream();
        this.out = this.auth.getOutputStream();
        this.msg = this.readMsg(this.in);
        this.handleRequest(this.msg);
    }

    private void handleRequest(ProxyMessage msg) throws IOException {
        if (!this.auth.checkRequest(msg)) {
            throw new SocksException(1);
        }
        if (msg.ip == null) {
            if (msg instanceof Socks5Message) {
                msg.ip = InetAddress.getByName(msg.host);
            } else {
                throw new SocksException(1);
            }
        }
        ProxyServer.log(msg);
        switch (msg.command) {
            case 1: {
                this.onConnect(msg);
                break;
            }
            case 2: {
                this.onBind(msg);
                break;
            }
            case 3: {
                this.onUDP(msg);
                break;
            }
            default: {
                throw new SocksException(7);
            }
        }
    }

    private void handleException(IOException ioe) {
        if (this.msg == null) {
            return;
        }
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 2) {
            return;
        }
        int error_code = 1;
        if (ioe instanceof SocksException) {
            error_code = ((SocksException)ioe).errCode;
        } else if (ioe instanceof NoRouteToHostException) {
            error_code = 4;
        } else if (ioe instanceof ConnectException) {
            error_code = 5;
        } else if (ioe instanceof InterruptedIOException) {
            error_code = 6;
        }
        if (error_code > 8 || error_code < 0) {
            error_code = 1;
        }
        this.sendErrorMessage(error_code);
    }

    private void onConnect(ProxyMessage msg) throws IOException {
        Socket s2 = proxy == null ? new Socket(msg.ip, msg.port) : new SocksSocket(proxy, msg.ip, msg.port);
        log.info("Connected to " + s2.getInetAddress() + ":" + s2.getPort());
        ProxyMessage response = null;
        InetAddress localAddress = s2.getLocalAddress();
        int localPort = s2.getLocalPort();
        if (msg instanceof Socks5Message) {
            boolean cmd = false;
            response = new Socks5Message(0, localAddress, localPort);
        } else {
            int cmd = 90;
            response = new Socks4Message(90, localAddress, localPort);
        }
        response.write(this.out);
        this.startPipe(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBind(ProxyMessage msg) throws IOException {
        int cmd;
        ProxyMessage response = null;
        this.ss = proxy == null ? new ServerSocket(0) : new SocksServerSocket(proxy, msg.ip, msg.port);
        this.ss.setSoTimeout(acceptTimeout);
        InetAddress inetAddress = this.ss.getInetAddress();
        int localPort = this.ss.getLocalPort();
        log.info("Trying accept on {}:{}", (Object)inetAddress, (Object)localPort);
        if (msg.version == 5) {
            cmd = 0;
            response = new Socks5Message(0, inetAddress, localPort);
        } else {
            cmd = 90;
            response = new Socks4Message(90, inetAddress, localPort);
        }
        response.write(this.out);
        this.mode = 1;
        this.pipe_thread1 = Thread.currentThread();
        this.pipe_thread2 = new Thread(this);
        this.pipe_thread2.start();
        this.sock.setSoTimeout(0);
        int eof = 0;
        try {
            while ((eof = this.in.read()) >= 0) {
                if (this.mode == 1) continue;
                if (this.mode != 2) {
                    return;
                }
                this.remote_out.write(eof);
                break;
            }
        }
        catch (EOFException e) {
            log.debug("Connection closed while we were trying to accept", e);
            return;
        }
        catch (InterruptedIOException e) {
            log.debug("Interrupted by unsucessful accept thread", e);
            if (this.mode != 2) {
                return;
            }
        }
        if (eof < 0) {
            return;
        }
        this.pipe(this.in, this.remote_out);
    }

    private void onUDP(ProxyMessage msg) throws IOException {
        if (msg.ip.getHostAddress().equals("0.0.0.0")) {
            msg.ip = this.sock.getInetAddress();
        }
        log.info("Creating UDP relay server for {}:{}", (Object)msg.ip, (Object)msg.port);
        this.relayServer = new UDPRelayServer(msg.ip, msg.port, Thread.currentThread(), this.sock, this.auth);
        Socks5Message response = new Socks5Message(0, this.relayServer.relayIP, this.relayServer.relayPort);
        ((ProxyMessage)response).write(this.out);
        this.relayServer.start();
        this.sock.setSoTimeout(0);
        try {
            while (this.in.read() >= 0) {
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private void doAccept() throws IOException {
        ProxyMessage response;
        Socket s2 = null;
        long startTime = System.currentTimeMillis();
        while (true) {
            if ((s2 = this.ss.accept()).getInetAddress().equals(this.msg.ip)) break;
            if (this.ss instanceof SocksServerSocket) {
                s2.close();
                this.ss.close();
                throw new SocksException(1);
            }
            if (acceptTimeout != 0) {
                long passed = System.currentTimeMillis() - startTime;
                int newTimeout = acceptTimeout - (int)passed;
                if (newTimeout <= 0) {
                    throw new InterruptedIOException("newTimeout <= 0");
                }
                this.ss.setSoTimeout(newTimeout);
            }
            s2.close();
        }
        this.ss.close();
        this.remote_sock = s2;
        this.remote_in = s2.getInputStream();
        this.remote_out = s2.getOutputStream();
        this.remote_sock.setSoTimeout(iddleTimeout);
        InetAddress inetAddress = s2.getInetAddress();
        int port = s2.getPort();
        log.info("Accepted from {}:{}", (Object)s2.getInetAddress(), (Object)port);
        if (this.msg.version == 5) {
            boolean cmd = false;
            response = new Socks5Message(0, inetAddress, port);
        } else {
            int cmd = 90;
            response = new Socks4Message(90, inetAddress, port);
        }
        response.write(this.out);
    }

    private ProxyMessage readMsg(InputStream in) throws IOException {
        ProxyMessage msg;
        PushbackInputStream push_in = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in);
        int version = push_in.read();
        push_in.unread(version);
        if (version == 5) {
            msg = new Socks5Message(push_in, false);
        } else if (version == 4) {
            msg = new Socks4Message(push_in, false);
        } else {
            throw new SocksException(1);
        }
        return msg;
    }

    private void startPipe(Socket s2) {
        this.mode = 2;
        this.remote_sock = s2;
        try {
            this.remote_in = s2.getInputStream();
            this.remote_out = s2.getOutputStream();
            this.pipe_thread1 = Thread.currentThread();
            this.pipe_thread2 = new Thread(this);
            this.pipe_thread2.start();
            this.pipe(this.in, this.remote_out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendErrorMessage(int error_code) {
        ProxyMessage err_msg = this.msg instanceof Socks4Message ? new Socks4Message(91) : new Socks5Message(error_code);
        try {
            err_msg.write(this.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void abort() {
        if (this.mode == 3) {
            return;
        }
        this.mode = 3;
        try {
            log.info("Aborting operation");
            if (this.remote_sock != null) {
                this.remote_sock.close();
            }
            if (this.sock != null) {
                this.sock.close();
            }
            if (this.relayServer != null) {
                this.relayServer.stop();
            }
            if (this.ss != null) {
                this.ss.close();
            }
            if (this.pipe_thread1 != null) {
                this.pipe_thread1.interrupt();
            }
            if (this.pipe_thread2 != null) {
                this.pipe_thread2.interrupt();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static final void log(ProxyMessage msg) {
        log.debug("Request version: {}, Command: ", (Object)msg.version, (Object)ProxyServer.command2String(msg.command));
        String user = msg.version == 4 ? ", User:" + msg.user : "";
        log.debug("IP:" + msg.ip + ", Port:" + msg.port + user);
    }

    private void pipe(InputStream in, OutputStream out) throws IOException {
        this.lastReadTime = System.currentTimeMillis();
        byte[] buf = new byte[8192];
        int len = 0;
        while (len >= 0) {
            try {
                if (len != 0) {
                    out.write(buf, 0, len);
                    out.flush();
                }
                len = in.read(buf);
                this.lastReadTime = System.currentTimeMillis();
            }
            catch (InterruptedIOException iioe) {
                if (iddleTimeout == 0) {
                    return;
                }
                long timeSinceRead = System.currentTimeMillis() - this.lastReadTime;
                if (timeSinceRead >= (long)(iddleTimeout - 1000)) {
                    return;
                }
                len = 0;
            }
        }
    }

    static final String command2String(int cmd) {
        if (cmd > 0 && cmd < 4) {
            return command_names[cmd - 1];
        }
        return "Unknown Command " + cmd;
    }

    static {
        command_names = new String[]{"CONNECT", "BIND", "UDP_ASSOCIATE"};
    }
}

