/*
 * Decompiled with CFR 0.152.
 */
package com.runjva.sourceforge.jsocks.protocol;

import com.runjva.sourceforge.jsocks.protocol.InetRange;
import com.runjva.sourceforge.jsocks.protocol.ProxyMessage;
import com.runjva.sourceforge.jsocks.protocol.Socks4Message;
import com.runjva.sourceforge.jsocks.protocol.SocksException;
import com.runjva.sourceforge.jsocks.protocol.SocksProxyBase;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Socks4Proxy
extends SocksProxyBase
implements Cloneable {
    String user;

    public Socks4Proxy(SocksProxyBase p, String proxyHost, int proxyPort, String user) throws UnknownHostException {
        super(p, proxyHost, proxyPort);
        this.user = new String(user);
        this.version = 4;
    }

    public Socks4Proxy(String proxyHost, int proxyPort, String user) throws UnknownHostException {
        this(null, proxyHost, proxyPort, user);
    }

    public Socks4Proxy(SocksProxyBase p, InetAddress proxyIP, int proxyPort, String user) {
        super(p, proxyIP, proxyPort);
        this.user = new String(user);
        this.version = 4;
    }

    public Socks4Proxy(InetAddress proxyIP, int proxyPort, String user) {
        this(null, proxyIP, proxyPort, user);
    }

    public Object clone() {
        Socks4Proxy newProxy = new Socks4Proxy(this.proxyIP, this.proxyPort, this.user);
        newProxy.directHosts = (InetRange)this.directHosts.clone();
        newProxy.chainProxy = this.chainProxy;
        return newProxy;
    }

    @Override
    protected SocksProxyBase copy() {
        Socks4Proxy copy = new Socks4Proxy(this.proxyIP, this.proxyPort, this.user);
        copy.directHosts = this.directHosts;
        copy.chainProxy = this.chainProxy;
        return copy;
    }

    @Override
    protected ProxyMessage formMessage(int cmd, InetAddress ip, int port) {
        switch (cmd) {
            case 1: {
                cmd = 1;
                break;
            }
            case 2: {
                cmd = 2;
                break;
            }
            default: {
                return null;
            }
        }
        return new Socks4Message(cmd, ip, port, this.user);
    }

    @Override
    protected ProxyMessage formMessage(int cmd, String host, int port) throws UnknownHostException {
        return this.formMessage(cmd, InetAddress.getByName(host), port);
    }

    @Override
    protected ProxyMessage formMessage(InputStream in) throws SocksException, IOException {
        return new Socks4Message(in, true);
    }
}

