/*
 * Decompiled with CFR 0.152.
 */
package com.runjva.sourceforge.jsocks.protocol;

import com.runjva.sourceforge.jsocks.protocol.ProxyMessage;
import com.runjva.sourceforge.jsocks.protocol.Socks5Message;
import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import com.runjva.sourceforge.jsocks.protocol.SocksException;
import com.runjva.sourceforge.jsocks.protocol.SocksProxyBase;
import com.runjva.sourceforge.jsocks.protocol.UDPEncapsulation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Socks5DatagramSocket
extends DatagramSocket {
    InetAddress relayIP;
    int relayPort;
    Socks5Proxy proxy;
    private boolean server_mode = false;
    UDPEncapsulation encapsulation;
    private Logger log = LoggerFactory.getLogger(Socks5DatagramSocket.class);

    public Socks5DatagramSocket() throws SocksException, IOException {
        this(SocksProxyBase.defaultProxy, 0, null);
    }

    public Socks5DatagramSocket(int port) throws SocksException, IOException {
        this(SocksProxyBase.defaultProxy, port, null);
    }

    public Socks5DatagramSocket(int port, InetAddress ip) throws SocksException, IOException {
        this(SocksProxyBase.defaultProxy, port, ip);
    }

    public Socks5DatagramSocket(SocksProxyBase p, int port, InetAddress ip) throws SocksException, IOException {
        super(port, ip);
        if (p == null) {
            throw new SocksException(65536);
        }
        if (!(p instanceof Socks5Proxy)) {
            String s2 = "Datagram Socket needs Proxy version 5";
            throw new SocksException(-1, "Datagram Socket needs Proxy version 5");
        }
        if (p.chainProxy != null) {
            String s3 = "Datagram Sockets do not support proxy chaining.";
            throw new SocksException(393216, "Datagram Sockets do not support proxy chaining.");
        }
        this.proxy = (Socks5Proxy)p.copy();
        ProxyMessage msg = this.proxy.udpAssociate(super.getLocalAddress(), super.getLocalPort());
        this.relayIP = msg.ip;
        if (this.relayIP.getHostAddress().equals("0.0.0.0")) {
            this.relayIP = this.proxy.proxyIP;
        }
        this.relayPort = msg.port;
        this.encapsulation = this.proxy.udp_encapsulation;
        this.log.debug("Datagram Socket:{}:{}", (Object)this.getLocalAddress(), (Object)this.getLocalPort());
        this.log.debug("Socks5Datagram: {}:{}", (Object)this.relayIP, (Object)this.relayPort);
    }

    Socks5DatagramSocket(boolean server_mode, UDPEncapsulation encapsulation, InetAddress relayIP, int relayPort) throws IOException {
        this.server_mode = server_mode;
        this.relayIP = relayIP;
        this.relayPort = relayPort;
        this.encapsulation = encapsulation;
        this.proxy = null;
    }

    @Override
    public void send(DatagramPacket dp) throws IOException {
        if (!this.server_mode && this.proxy.isDirect(dp.getAddress())) {
            super.send(dp);
            this.log.debug("Sending datagram packet directly:");
            return;
        }
        byte[] head = this.formHeader(dp.getAddress(), dp.getPort());
        byte[] buf = new byte[head.length + dp.getLength()];
        byte[] data = dp.getData();
        System.arraycopy(head, 0, buf, 0, head.length);
        System.arraycopy(data, 0, buf, head.length, dp.getLength());
        if (this.encapsulation != null) {
            buf = this.encapsulation.udpEncapsulate(buf, true);
        }
        super.send(new DatagramPacket(buf, buf.length, this.relayIP, this.relayPort));
    }

    public void send(DatagramPacket dp, String host) throws IOException {
        if (this.proxy.isDirect(host)) {
            dp.setAddress(InetAddress.getByName(host));
            super.send(dp);
            return;
        }
        if (this.proxy.resolveAddrLocally) {
            dp.setAddress(InetAddress.getByName(host));
        }
        byte[] head = this.formHeader(host, dp.getPort());
        byte[] buf = new byte[head.length + dp.getLength()];
        byte[] data = dp.getData();
        System.arraycopy(head, 0, buf, 0, head.length);
        System.arraycopy(data, 0, buf, head.length, dp.getLength());
        if (this.encapsulation != null) {
            buf = this.encapsulation.udpEncapsulate(buf, true);
        }
        super.send(new DatagramPacket(buf, buf.length, this.relayIP, this.relayPort));
    }

    @Override
    public void receive(DatagramPacket dp) throws IOException {
        super.receive(dp);
        if (this.server_mode) {
            int init_length = dp.getLength();
            int initTimeout = this.getSoTimeout();
            long startTime = System.currentTimeMillis();
            while (!this.relayIP.equals(dp.getAddress()) || this.relayPort != dp.getPort()) {
                dp.setLength(init_length);
                if (initTimeout != 0) {
                    long passed = System.currentTimeMillis() - startTime;
                    int newTimeout = initTimeout - (int)passed;
                    if (newTimeout <= 0) {
                        throw new InterruptedIOException("In Socks5DatagramSocket->receive()");
                    }
                    this.setSoTimeout(newTimeout);
                }
                super.receive(dp);
            }
            if (initTimeout != 0) {
                this.setSoTimeout(initTimeout);
            }
        } else if (!this.relayIP.equals(dp.getAddress()) || this.relayPort != dp.getPort()) {
            return;
        }
        byte[] data = dp.getData();
        if (this.encapsulation != null) {
            data = this.encapsulation.udpEncapsulate(data, false);
        }
        boolean offset = false;
        ByteArrayInputStream bIn = new ByteArrayInputStream(data, 0, dp.getLength());
        Socks5Message msg = new Socks5Message(bIn);
        dp.setPort(msg.port);
        dp.setAddress(((ProxyMessage)msg).getInetAddress());
        int data_length = bIn.available();
        System.arraycopy(data, 0 + dp.getLength() - data_length, data, 0, data_length);
        dp.setLength(data_length);
    }

    @Override
    public int getLocalPort() {
        if (this.server_mode) {
            return super.getLocalPort();
        }
        return this.relayPort;
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.server_mode) {
            return super.getLocalAddress();
        }
        return this.relayIP;
    }

    @Override
    public void close() {
        if (!this.server_mode) {
            this.proxy.endSession();
        }
        super.close();
    }

    public boolean isProxyAlive(int timeout) {
        if (this.server_mode) {
            return false;
        }
        if (this.proxy != null) {
            try {
                this.proxy.proxySocket.setSoTimeout(timeout);
                int eof = this.proxy.in.read();
                if (eof < 0) {
                    return false;
                }
                this.log.warn("This really should not happen");
                return true;
            }
            catch (InterruptedIOException iioe) {
                return true;
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return false;
    }

    private byte[] formHeader(InetAddress ip, int port) {
        Socks5Message request = new Socks5Message(0, ip, port);
        request.data[0] = 0;
        return request.data;
    }

    private byte[] formHeader(String host, int port) {
        Socks5Message request = new Socks5Message(0, host, port);
        request.data[0] = 0;
        return request.data;
    }
}

