/*
 * Decompiled with CFR 0.152.
 */
package com.runjva.sourceforge.jsocks.protocol;

import com.runjva.sourceforge.jsocks.protocol.Authentication;
import com.runjva.sourceforge.jsocks.protocol.AuthenticationNone;
import com.runjva.sourceforge.jsocks.protocol.InetRange;
import com.runjva.sourceforge.jsocks.protocol.ProxyMessage;
import com.runjva.sourceforge.jsocks.protocol.Socks5Message;
import com.runjva.sourceforge.jsocks.protocol.SocksException;
import com.runjva.sourceforge.jsocks.protocol.SocksProxyBase;
import com.runjva.sourceforge.jsocks.protocol.UDPEncapsulation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Socks5Proxy
extends SocksProxyBase
implements Cloneable {
    private Hashtable<Integer, Authentication> authMethods = new Hashtable();
    private int selectedMethod;
    boolean resolveAddrLocally = true;
    UDPEncapsulation udp_encapsulation = null;

    public Socks5Proxy(SocksProxyBase p, String proxyHost, int proxyPort) throws UnknownHostException {
        super(p, proxyHost, proxyPort);
        this.version = 5;
        this.setAuthenticationMethod(0, new AuthenticationNone());
    }

    public Socks5Proxy(String proxyHost, int proxyPort) throws UnknownHostException {
        this(null, proxyHost, proxyPort);
    }

    public Socks5Proxy(SocksProxyBase p, InetAddress proxyIP, int proxyPort) {
        super(p, proxyIP, proxyPort);
        this.version = 5;
        this.setAuthenticationMethod(0, new AuthenticationNone());
    }

    public Socks5Proxy(InetAddress proxyIP, int proxyPort) {
        this(null, proxyIP, proxyPort);
    }

    public boolean resolveAddrLocally(boolean doResolve) {
        boolean old = this.resolveAddrLocally;
        this.resolveAddrLocally = doResolve;
        return old;
    }

    public boolean resolveAddrLocally() {
        return this.resolveAddrLocally;
    }

    public boolean setAuthenticationMethod(int methodId, Authentication method) {
        if (methodId < 0 || methodId > 255) {
            return false;
        }
        if (method == null) {
            return this.authMethods.remove(new Integer(methodId)) != null;
        }
        this.authMethods.put(new Integer(methodId), method);
        return true;
    }

    public Authentication getAuthenticationMethod(int methodId) {
        Authentication method = this.authMethods.get(new Integer(methodId));
        if (method == null) {
            return null;
        }
        return method;
    }

    public Object clone() {
        Socks5Proxy newProxy = new Socks5Proxy(this.proxyIP, this.proxyPort);
        Object o = this.authMethods.clone();
        newProxy.authMethods = (Hashtable)o;
        newProxy.directHosts = (InetRange)this.directHosts.clone();
        newProxy.resolveAddrLocally = this.resolveAddrLocally;
        newProxy.chainProxy = this.chainProxy;
        return newProxy;
    }

    @Override
    protected SocksProxyBase copy() {
        Socks5Proxy copy = new Socks5Proxy(this.proxyIP, this.proxyPort);
        copy.authMethods = this.authMethods;
        copy.directHosts = this.directHosts;
        copy.chainProxy = this.chainProxy;
        copy.resolveAddrLocally = this.resolveAddrLocally;
        return copy;
    }

    @Override
    protected void startSession() throws SocksException {
        super.startSession();
        Socket ps = this.proxySocket;
        try {
            byte nMethods = (byte)this.authMethods.size();
            byte[] buf = new byte[2 + nMethods];
            buf[0] = (byte)this.version;
            buf[1] = nMethods;
            int i = 2;
            Enumeration<Integer> ids = this.authMethods.keys();
            while (ids.hasMoreElements()) {
                buf[i++] = (byte)ids.nextElement().intValue();
            }
            this.out.write(buf);
            this.out.flush();
            int versionNumber = this.in.read();
            this.selectedMethod = this.in.read();
            if (versionNumber < 0 || this.selectedMethod < 0) {
                this.endSession();
                String s2 = "Connection to proxy lost.";
                throw new SocksException(196608, "Connection to proxy lost.");
            }
            if (versionNumber < this.version) {
                // empty if block
            }
            if (this.selectedMethod == 255) {
                ps.close();
                throw new SocksException(262144);
            }
            Authentication auth = this.getAuthenticationMethod(this.selectedMethod);
            if (auth == null) {
                String s3 = "Specified Authentication not found!";
                throw new SocksException(393216, "Specified Authentication not found!");
            }
            Object[] in_out = auth.doSocksAuthentication(this.selectedMethod, ps);
            if (in_out == null) {
                throw new SocksException(327680);
            }
            this.in = (InputStream)in_out[0];
            this.out = (OutputStream)in_out[1];
            if (in_out.length > 2) {
                this.udp_encapsulation = (UDPEncapsulation)in_out[2];
            }
        }
        catch (SocksException s_ex) {
            throw s_ex;
        }
        catch (UnknownHostException uh_ex) {
            throw new SocksException(131072, (Throwable)uh_ex);
        }
        catch (SocketException so_ex) {
            throw new SocksException(131072, (Throwable)so_ex);
        }
        catch (IOException io_ex) {
            throw new SocksException(196608, (Throwable)io_ex);
        }
    }

    @Override
    protected ProxyMessage formMessage(int cmd, InetAddress ip, int port) {
        return new Socks5Message(cmd, ip, port);
    }

    @Override
    protected ProxyMessage formMessage(int cmd, String host, int port) throws UnknownHostException {
        if (this.resolveAddrLocally) {
            return this.formMessage(cmd, InetAddress.getByName(host), port);
        }
        return new Socks5Message(cmd, host, port);
    }

    @Override
    protected ProxyMessage formMessage(InputStream in) throws SocksException, IOException {
        return new Socks5Message(in);
    }
}

