/*
 * Decompiled with CFR 0.152.
 */
package com.runjva.sourceforge.jsocks.server;

import com.runjva.sourceforge.jsocks.server.ServerAuthenticator;
import com.runjva.sourceforge.jsocks.server.ServerAuthenticatorBase;
import com.runjva.sourceforge.jsocks.server.ServerAuthenticatorNone;
import com.runjva.sourceforge.jsocks.server.UserValidation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class UserPasswordAuthenticator
extends ServerAuthenticatorBase {
    static final int METHOD_ID = 2;
    UserValidation validator;

    public UserPasswordAuthenticator(UserValidation validator) {
        this.validator = validator;
    }

    @Override
    public ServerAuthenticator startSession(Socket s2) throws IOException {
        InputStream in = s2.getInputStream();
        OutputStream out = s2.getOutputStream();
        if (in.read() != 5) {
            return null;
        }
        if (!UserPasswordAuthenticator.selectSocks5Authentication(in, out, 2)) {
            return null;
        }
        if (!this.doUserPasswordAuthentication(s2, in, out)) {
            return null;
        }
        return new ServerAuthenticatorNone(in, out);
    }

    private boolean doUserPasswordAuthentication(Socket s2, InputStream in, OutputStream out) throws IOException {
        int version = in.read();
        if (version != 1) {
            return false;
        }
        int ulen = in.read();
        if (ulen < 0) {
            return false;
        }
        byte[] user = new byte[ulen];
        in.read(user);
        int plen = in.read();
        if (plen < 0) {
            return false;
        }
        byte[] password = new byte[plen];
        in.read(password);
        if (!this.validator.isUserValid(new String(user), new String(password), s2)) {
            out.write(new byte[]{1, 1});
            return false;
        }
        out.write(new byte[]{1, 0});
        return true;
    }
}

