/*
 * Decompiled with CFR 0.152.
 */
package haveno.asset;

import haveno.asset.AddressValidationResult;
import haveno.asset.AddressValidator;
import haveno.asset.Asset;
import org.apache.commons.lang3.Validate;

public abstract class AbstractAsset
implements Asset {
    private final String name;
    private final String tickerSymbol;
    private final AddressValidator addressValidator;

    public AbstractAsset(String name, String tickerSymbol, AddressValidator addressValidator) {
        this.name = Validate.notBlank(name);
        this.tickerSymbol = Validate.notBlank(tickerSymbol);
        this.addressValidator = Validate.notNull(addressValidator);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getTickerSymbol() {
        return this.tickerSymbol;
    }

    @Override
    public final AddressValidationResult validateAddress(String address) {
        return this.addressValidator.validate(address);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

