/*
 * Decompiled with CFR 0.152.
 */
package haveno.asset;

import haveno.asset.AddressValidationResult;
import haveno.asset.AddressValidator;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.LegacyAddress;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.params.MainNetParams;

public class Base58AddressValidator
implements AddressValidator {
    private final NetworkParameters networkParameters;

    public Base58AddressValidator() {
        this(MainNetParams.get());
    }

    public Base58AddressValidator(NetworkParameters networkParameters) {
        this.networkParameters = networkParameters;
    }

    @Override
    public AddressValidationResult validate(String address) {
        try {
            LegacyAddress.fromBase58(this.networkParameters, address);
        }
        catch (AddressFormatException ex) {
            return AddressValidationResult.invalidAddress(ex);
        }
        return AddressValidationResult.validAddress();
    }
}

