/*
 * Decompiled with CFR 0.152.
 */
package haveno.asset;

import haveno.asset.AddressValidationResult;
import haveno.asset.AddressValidator;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.params.MainNetParams;

public class BitcoinAddressValidator
implements AddressValidator {
    private final NetworkParameters networkParameters;

    public BitcoinAddressValidator() {
        this(MainNetParams.get());
    }

    public BitcoinAddressValidator(NetworkParameters networkParameters) {
        this.networkParameters = networkParameters;
    }

    @Override
    public AddressValidationResult validate(String address) {
        try {
            Address.fromString(this.networkParameters, address);
        }
        catch (AddressFormatException ex) {
            return AddressValidationResult.invalidAddress(ex);
        }
        return AddressValidationResult.validAddress();
    }
}

