/*
 * Decompiled with CFR 0.152.
 */
package haveno.asset;

import haveno.asset.AddressValidationResult;
import haveno.asset.AddressValidator;

public class GrinAddressValidator
implements AddressValidator {
    private static final String PORT = "((6553[0-5])|(655[0-2][0-9])|(65[0-4][0-9]{2})|(6[0-4][0-9]{3})|([1-5][0-9]{4})|([0-5]{0,5})|([0-9]{1,4}))$";
    private static final String DOMAIN = "[a-zA-Z0-9][a-zA-Z0-9-]{1,61}[a-zA-Z0-9]\\.[a-zA-Z]{2,}$";
    private static final String KEY = "[a-km-zA-HJ-NP-Z1-9]{52}$";

    @Override
    public AddressValidationResult validate(String address) {
        String key;
        if (address == null || address.length() == 0) {
            return AddressValidationResult.invalidAddress("Address may not be empty (only Grinbox format is supported)");
        }
        String domain = null;
        String port = null;
        if ((address = address.replace("grinbox://", "")).contains("@")) {
            String[] keyAndDomain = address.split("@");
            key = keyAndDomain[0];
            if (keyAndDomain.length > 1 && (domain = keyAndDomain[1]).contains(":")) {
                String[] domainAndPort = domain.split(":");
                domain = domainAndPort[0];
                if (domainAndPort.length > 1) {
                    port = domainAndPort[1];
                }
            }
        } else {
            key = address;
        }
        if (!key.matches("^[a-km-zA-HJ-NP-Z1-9]{52}$")) {
            return AddressValidationResult.invalidAddress("Invalid key (only Grinbox format is supported)");
        }
        if (domain != null && !domain.matches("^[a-zA-Z0-9][a-zA-Z0-9-]{1,61}[a-zA-Z0-9]\\.[a-zA-Z]{2,}$")) {
            return AddressValidationResult.invalidAddress("Invalid domain (only Grinbox format is supported)");
        }
        if (port != null && !port.matches("^((6553[0-5])|(655[0-2][0-9])|(65[0-4][0-9]{2})|(6[0-4][0-9]{3})|([1-5][0-9]{4})|([0-5]{0,5})|([0-9]{1,4}))$")) {
            return AddressValidationResult.invalidAddress("Invalid port (only Grinbox format is supported)");
        }
        return AddressValidationResult.validAddress();
    }
}

