/*
 * Decompiled with CFR 0.152.
 */
package haveno.common;

import com.google.inject.Singleton;
import haveno.common.Timer;
import haveno.common.UserThread;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ClockWatcher {
    private static final Logger log = LoggerFactory.getLogger(ClockWatcher.class);
    public static final int IDLE_TOLERANCE_MS = 20000;
    private Timer timer;
    private final List<Listener> listeners = new LinkedList<Listener>();
    private long counter = 0L;
    private long lastSecondTick;

    public void start() {
        if (this.timer == null) {
            this.lastSecondTick = System.currentTimeMillis();
            this.timer = UserThread.runPeriodically(() -> {
                List<Listener> list = this.listeners;
                synchronized (list) {
                    long currentTimeMillis;
                    long diff;
                    this.listeners.forEach(Listener::onSecondTick);
                    ++this.counter;
                    if (this.counter >= 60L) {
                        this.counter = 0L;
                        this.listeners.forEach(Listener::onMinuteTick);
                    }
                    if ((diff = (currentTimeMillis = System.currentTimeMillis()) - this.lastSecondTick) > 1000L) {
                        long missedMs = diff - 1000L;
                        this.listeners.forEach(listener -> listener.onMissedSecondTick(missedMs));
                        if (missedMs > 20000L) {
                            log.warn("We have been in standby mode for {} sec", (Object)(missedMs / 1000L));
                            this.listeners.forEach(listener -> listener.onAwakeFromStandby(missedMs));
                        }
                    }
                    this.lastSecondTick = currentTimeMillis;
                }
            }, 1L, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        this.timer.stop();
        this.timer = null;
        this.counter = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public static interface Listener {
        public void onSecondTick();

        public void onMinuteTick();

        default public void onMissedSecondTick(long missedMs) {
        }

        default public void onAwakeFromStandby(long missedMs) {
        }
    }
}

