/*
 * Decompiled with CFR 0.152.
 */
package haveno.common;

import haveno.common.MasterTimer;
import haveno.common.Timer;
import java.time.Duration;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameRateTimer
implements Timer,
Runnable {
    private final Logger log = LoggerFactory.getLogger(FrameRateTimer.class);
    private long interval;
    private Runnable runnable;
    private long startTs;
    private boolean isPeriodically;
    private final String uid = UUID.randomUUID().toString();
    private volatile boolean stopped;

    @Override
    public void run() {
        if (!this.stopped) {
            try {
                long currentTimeMillis = System.currentTimeMillis();
                if (currentTimeMillis - this.startTs >= this.interval) {
                    this.runnable.run();
                    if (this.isPeriodically) {
                        this.startTs = currentTimeMillis;
                    } else {
                        this.stop();
                    }
                }
            }
            catch (Throwable t2) {
                this.log.error("exception in FrameRateTimer", t2);
                this.stop();
                throw t2;
            }
        }
    }

    @Override
    public Timer runLater(Duration delay, Runnable runnable) {
        this.interval = delay.toMillis();
        this.runnable = runnable;
        this.startTs = System.currentTimeMillis();
        MasterTimer.addListener(this);
        return this;
    }

    @Override
    public Timer runPeriodically(Duration interval, Runnable runnable) {
        this.interval = interval.toMillis();
        this.isPeriodically = true;
        this.runnable = runnable;
        this.startTs = System.currentTimeMillis();
        MasterTimer.addListener(this);
        return this;
    }

    @Override
    public void stop() {
        this.stopped = true;
        MasterTimer.removeListener(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FrameRateTimer)) {
            return false;
        }
        FrameRateTimer that = (FrameRateTimer)o;
        return !(this.uid == null ? that.uid != null : !this.uid.equals(that.uid));
    }

    public int hashCode() {
        return this.uid != null ? this.uid.hashCode() : 0;
    }
}

