/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.app;

import com.google.common.base.Joiner;
import haveno.common.app.Capability;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Capabilities {
    private static final Logger log = LoggerFactory.getLogger(Capabilities.class);
    public static final Capabilities app = new Capabilities(new Capability[0]);
    private static final Capability MANDATORY_CAPABILITY = Capability.TRADE_STATISTICS_3;
    protected final Set<Capability> capabilities = new HashSet<Capability>();

    public Capabilities(Capability ... capabilities) {
        this(Arrays.asList(capabilities));
    }

    public Capabilities(Capabilities capabilities) {
        this(capabilities.capabilities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Capabilities(Collection<Capability> capabilities) {
        Collection<Capability> collection = capabilities;
        synchronized (collection) {
            Set<Capability> set = this.capabilities;
            synchronized (set) {
                this.capabilities.addAll(capabilities);
            }
        }
    }

    public void set(Capability ... capabilities) {
        this.set(Arrays.asList(capabilities));
    }

    public void set(Capabilities capabilities) {
        this.set(capabilities.capabilities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Collection<Capability> capabilities) {
        Collection<Capability> collection = capabilities;
        synchronized (collection) {
            Set<Capability> set = this.capabilities;
            synchronized (set) {
                this.capabilities.clear();
                this.capabilities.addAll(capabilities);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Capability ... capabilities) {
        Set<Capability> set = this.capabilities;
        synchronized (set) {
            this.capabilities.addAll(Arrays.asList(capabilities));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Capabilities capabilities) {
        if (capabilities != null) {
            Set<Capability> set = capabilities.capabilities;
            synchronized (set) {
                Set<Capability> set2 = this.capabilities;
                synchronized (set2) {
                    this.capabilities.addAll(capabilities.capabilities);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Set<Capability> requiredItems) {
        Set<Capability> set = requiredItems;
        synchronized (set) {
            Set<Capability> set2 = this.capabilities;
            synchronized (set2) {
                return this.capabilities.containsAll(requiredItems);
            }
        }
    }

    public boolean containsAll(Capabilities capabilities) {
        return this.containsAll(capabilities.capabilities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Capability ... capabilities) {
        Set<Capability> set = this.capabilities;
        synchronized (set) {
            return this.capabilities.containsAll(Arrays.asList(capabilities));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Capability capability) {
        Set<Capability> set = this.capabilities;
        synchronized (set) {
            return this.capabilities.contains((Object)capability);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Set<Capability> set = this.capabilities;
        synchronized (set) {
            return this.capabilities.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> toIntList(Capabilities capabilities) {
        Set<Capability> set = capabilities.capabilities;
        synchronized (set) {
            return capabilities.capabilities.stream().map(Enum::ordinal).sorted().collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Capabilities fromIntList(List<Integer> capabilities) {
        List<Integer> list = capabilities;
        synchronized (list) {
            return new Capabilities(capabilities.stream().filter(integer -> integer < Capability.values().length).filter(integer -> integer >= 0).map(integer -> Capability.values()[integer]).collect(Collectors.toSet()));
        }
    }

    public static Capabilities fromStringList(String list) {
        if (list == null || list.isEmpty()) {
            return new Capabilities(new Capability[0]);
        }
        List<String> entries = List.of(list.replace(" ", "").split(","));
        List<Integer> capabilitiesList = entries.stream().map(c -> {
            try {
                return Integer.parseInt(c);
            }
            catch (Throwable e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return Capabilities.fromIntList(capabilitiesList);
    }

    public String toStringList() {
        return Joiner.on(", ").join(Capabilities.toIntList(this));
    }

    public static boolean hasMandatoryCapability(Capabilities capabilities) {
        return Capabilities.hasMandatoryCapability(capabilities, MANDATORY_CAPABILITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasMandatoryCapability(Capabilities capabilities, Capability mandatoryCapability) {
        Set<Capability> set = capabilities.capabilities;
        synchronized (set) {
            return capabilities.capabilities.stream().anyMatch(c -> c == mandatoryCapability);
        }
    }

    public String toString() {
        return Arrays.toString(Capabilities.toIntList(this).toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prettyPrint() {
        Set<Capability> set = this.capabilities;
        synchronized (set) {
            return this.capabilities.stream().sorted(Comparator.comparingInt(Enum::ordinal)).map(e -> e.name() + " [" + e.ordinal() + "]").collect(Collectors.joining(", "));
        }
    }

    public int size() {
        return this.capabilities.size();
    }

    public boolean hasLess(Capabilities other) {
        return this.findHighestCapability(this) < this.findHighestCapability(other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findHighestCapability(Capabilities capabilities) {
        Set<Capability> set = capabilities.capabilities;
        synchronized (set) {
            return (int)capabilities.capabilities.stream().mapToLong(e -> e.ordinal()).sum();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Capabilities)) {
            return false;
        }
        Capabilities other = (Capabilities)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<Capability> this$capabilities = this.capabilities;
        Set<Capability> other$capabilities = other.capabilities;
        return !(this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Capabilities;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Capability> $capabilities = this.capabilities;
        result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
        return result;
    }
}

