/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.app;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import org.slf4j.LoggerFactory;

public class Log {
    private static Logger logbackLogger;

    public static void setLevel(Level logLevel) {
        logbackLogger.setLevel(logLevel);
    }

    public static void setup(String fileName) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        RollingFileAppender<ILoggingEvent> appender = new RollingFileAppender<ILoggingEvent>();
        appender.setContext(loggerContext);
        appender.setFile(fileName + ".log");
        FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
        rollingPolicy.setContext(loggerContext);
        rollingPolicy.setParent(appender);
        rollingPolicy.setFileNamePattern(fileName + "_%i.log");
        rollingPolicy.setMinIndex(1);
        rollingPolicy.setMaxIndex(20);
        rollingPolicy.start();
        SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
        triggeringPolicy.setMaxFileSize(FileSize.valueOf("10MB"));
        triggeringPolicy.setContext(loggerContext);
        triggeringPolicy.start();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext(loggerContext);
        encoder.setPattern("%d{MMM-dd HH:mm:ss.SSS} [%thread] %-5level %logger{15}: %msg%n");
        encoder.start();
        appender.setEncoder(encoder);
        appender.setRollingPolicy(rollingPolicy);
        appender.setTriggeringPolicy(triggeringPolicy);
        appender.start();
        PatternLayoutEncoder errorEncoder = new PatternLayoutEncoder();
        errorEncoder.setContext(loggerContext);
        errorEncoder.setPattern("%d{MMM-dd HH:mm:ss.SSS} [%thread] %-5level %logger: %msg%n%ex");
        errorEncoder.start();
        RollingFileAppender<ILoggingEvent> errorAppender = new RollingFileAppender<ILoggingEvent>();
        errorAppender.setEncoder(errorEncoder);
        errorAppender.setName("Error");
        errorAppender.setContext(loggerContext);
        errorAppender.setFile(fileName + "_error.log");
        FixedWindowRollingPolicy errorRollingPolicy = new FixedWindowRollingPolicy();
        errorRollingPolicy.setContext(loggerContext);
        errorRollingPolicy.setParent(errorAppender);
        errorRollingPolicy.setFileNamePattern(fileName + "_error_%i.log");
        errorRollingPolicy.setMinIndex(1);
        errorRollingPolicy.setMaxIndex(20);
        errorRollingPolicy.start();
        SizeBasedTriggeringPolicy errorTriggeringPolicy = new SizeBasedTriggeringPolicy();
        errorTriggeringPolicy.setMaxFileSize(FileSize.valueOf("10MB"));
        errorTriggeringPolicy.start();
        ThresholdFilter thresholdFilter = new ThresholdFilter();
        thresholdFilter.setLevel("WARN");
        thresholdFilter.start();
        errorAppender.setRollingPolicy(errorRollingPolicy);
        errorAppender.setTriggeringPolicy(errorTriggeringPolicy);
        errorAppender.addFilter(thresholdFilter);
        errorAppender.start();
        logbackLogger = loggerContext.getLogger("ROOT");
        logbackLogger.addAppender((Appender<ILoggingEvent>)errorAppender);
        logbackLogger.addAppender((Appender<ILoggingEvent>)appender);
        logbackLogger.setLevel(Level.INFO);
    }

    public static void setCustomLogLevel(String pattern, Level logLevel) {
        ((Logger)LoggerFactory.getLogger(pattern)).setLevel(logLevel);
    }
}

