/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.config;

import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.params.RegTestParams;
import org.bitcoinj.utils.MonetaryFormat;

public enum BaseCurrencyNetwork {
    XMR_MAINNET(new XmrMainNetParams(), "XMR", "MAINNET", "Monero"),
    XMR_STAGENET(new XmrStageNetParams(), "XMR", "STAGENET", "Monero"),
    XMR_LOCAL(new XmrTestNetParams(), "XMR", "TESTNET", "Monero");

    private final NetworkParameters parameters;
    private final String currencyCode;
    private final String network;
    private final String currencyName;
    private static final MonetaryFormat XMR_MONETARY_FORMAT;

    private BaseCurrencyNetwork(NetworkParameters parameters, String currencyCode, String network, String currencyName) {
        this.parameters = parameters;
        this.currencyCode = currencyCode;
        this.network = network;
        this.currencyName = currencyName;
    }

    public boolean isMainnet() {
        return "XMR_MAINNET".equals(this.name());
    }

    public boolean isTestnet() {
        return "XMR_LOCAL".equals(this.name());
    }

    public boolean isStagenet() {
        return "XMR_STAGENET".equals(this.name());
    }

    public long getDefaultMinFeePerVbyte() {
        return 15L;
    }

    public NetworkParameters getParameters() {
        return this.parameters;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getCurrencyName() {
        return this.currencyName;
    }

    static {
        XMR_MONETARY_FORMAT = new MonetaryFormat().minDecimals(2).repeatOptionalDecimals(2, 3).noCode().code(0, "XMR");
    }

    private static class XmrMainNetParams
    extends MainNetParams {
        private XmrMainNetParams() {
        }

        @Override
        public MonetaryFormat getMonetaryFormat() {
            return XMR_MONETARY_FORMAT;
        }
    }

    private static class XmrStageNetParams
    extends MainNetParams {
        private XmrStageNetParams() {
        }

        @Override
        public MonetaryFormat getMonetaryFormat() {
            return XMR_MONETARY_FORMAT;
        }
    }

    private static class XmrTestNetParams
    extends RegTestParams {
        private XmrTestNetParams() {
        }

        @Override
        public MonetaryFormat getMonetaryFormat() {
            return XMR_MONETARY_FORMAT;
        }
    }
}

