/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.config;

import haveno.common.config.ConfigException;
import haveno.common.config.ConfigFileOption;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.Collectors;

class ConfigFileReader {
    private final File file;

    public ConfigFileReader(File file) {
        this.file = file;
    }

    public List<String> getLines() {
        if (!this.file.exists()) {
            throw new ConfigException("Config file %s does not exist", this.file);
        }
        if (!this.file.canRead()) {
            throw new ConfigException("Config file %s is not readable", this.file);
        }
        try {
            return Files.readAllLines(this.file.toPath()).stream().map(ConfigFileReader::cleanLine).collect(Collectors.toList());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public List<String> getOptionLines() {
        return this.getLines().stream().filter(ConfigFileOption::isOption).collect(Collectors.toList());
    }

    private static String cleanLine(String line) {
        return ConfigFileOption.isOption(line) ? ConfigFileOption.clean(line) : line;
    }
}

