/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.config;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import haveno.common.config.ConfigException;
import java.util.HashSet;
import joptsimple.ValueConverter;

class EnumValueConverter
implements ValueConverter<Enum> {
    private final Class<? extends Enum> enumType;

    public EnumValueConverter(Class<? extends Enum> enumType) {
        this.enumType = enumType;
    }

    @Override
    public Enum convert(String value) {
        HashSet<String> candidates = Sets.newHashSet(value, value.toUpperCase(), value.toLowerCase());
        for (String candidate : candidates) {
            Optional<? extends Enum> result = Enums.getIfPresent(this.enumType, candidate);
            if (!result.isPresent()) continue;
            return result.get();
        }
        throw new ConfigException("Enum label %s.{%s} does not exist", this.enumType.getSimpleName(), String.join((CharSequence)"|", candidates));
    }

    @Override
    public Class<? extends Enum> valueType() {
        return this.enumType;
    }

    @Override
    public String valuePattern() {
        return null;
    }
}

