/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.crypto;

import com.google.common.base.Charsets;
import haveno.common.crypto.CryptoException;
import haveno.common.crypto.KeyConversionException;
import haveno.common.util.Base64;
import haveno.common.util.Utilities;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sig {
    private static final Logger log = LoggerFactory.getLogger(Sig.class);
    public static final String KEY_ALGO = "DSA";
    private static final String ALGO = "SHA256withDSA";

    public static KeyPair generateKeyPair() {
        long ts = System.currentTimeMillis();
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGO);
            keyPairGenerator.initialize(2048);
            return keyPairGenerator.genKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Could not create key.", e);
            throw new RuntimeException("Could not create key.");
        }
    }

    public static byte[] sign(PrivateKey privateKey, byte[] data) throws CryptoException {
        try {
            Signature sig = Signature.getInstance(ALGO);
            sig.initSign(privateKey);
            sig.update(data);
            return sig.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new CryptoException("Signing failed. " + e.getMessage());
        }
    }

    public static String sign(PrivateKey privateKey, String message) throws CryptoException {
        byte[] sigAsBytes = Sig.sign(privateKey, message.getBytes(Charsets.UTF_8));
        return Base64.encode(sigAsBytes);
    }

    public static boolean verify(PublicKey publicKey, byte[] data, byte[] signature) throws CryptoException {
        try {
            Signature sig = Signature.getInstance(ALGO);
            sig.initVerify(publicKey);
            sig.update(data);
            return sig.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new CryptoException("Signature verification failed", e);
        }
    }

    public static boolean verify(PublicKey publicKey, String message, String signature) throws CryptoException {
        return Sig.verify(publicKey, message.getBytes(Charsets.UTF_8), Base64.decode(signature));
    }

    public static PublicKey getPublicKeyFromBytes(byte[] sigPublicKeyBytes) {
        try {
            return KeyFactory.getInstance(KEY_ALGO).generatePublic(new X509EncodedKeySpec(sigPublicKeyBytes));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            log.error("Error creating sigPublicKey from bytes. sigPublicKeyBytes as hex={}, error={}", (Object)Utilities.bytesAsHexString(sigPublicKeyBytes), (Object)e);
            e.printStackTrace();
            throw new KeyConversionException(e);
        }
    }

    public static byte[] getPublicKeyBytes(PublicKey sigPublicKey) {
        return new X509EncodedKeySpec(sigPublicKey.getEncoded()).getEncoded();
    }
}

