/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.file;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CorruptedStorageFileHandler {
    private static final Logger log = LoggerFactory.getLogger(CorruptedStorageFileHandler.class);
    private final List<String> files = new ArrayList<String>();

    @Inject
    public CorruptedStorageFileHandler() {
    }

    public void addFile(String fileName) {
        this.files.add(fileName);
    }

    public Optional<List<String>> getFiles() {
        if (this.files.isEmpty()) {
            return Optional.empty();
        }
        if (this.files.size() == 1 && this.files.get(0).equals("ViewPathAsString")) {
            log.debug("We detected incompatible data base file for Navigation. That is a minor issue happening with refactoring of UI classes and we don't display a warning popup to the user.");
            return Optional.empty();
        }
        return Optional.of(this.files);
    }
}

