/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.file;

import haveno.common.file.FileUtil;
import haveno.common.util.Utilities;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFileManager {
    private static final Logger log = LoggerFactory.getLogger(JsonFileManager.class);
    private static final List<JsonFileManager> INSTANCES = new ArrayList<JsonFileManager>();
    @Nullable
    private ThreadPoolExecutor executor;
    private final File dir;

    public static void shutDownAllInstances() {
        INSTANCES.forEach(JsonFileManager::shutDown);
    }

    public JsonFileManager(File dir) {
        this.dir = dir;
        if (!dir.exists() && !dir.mkdir()) {
            log.warn("make dir failed");
        }
        INSTANCES.add(this);
    }

    @NotNull
    protected ThreadPoolExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = Utilities.getThreadPoolExecutor("JsonFileManagerExecutor", 5, 50, 60L);
        }
        return this.executor;
    }

    public void shutDown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public void writeToDiscThreaded(String json, String fileName) {
        this.getExecutor().execute(() -> this.writeToDisc(json, fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDisc(String json, String fileName) {
        File jsonFile = new File(Paths.get(this.dir.getAbsolutePath(), fileName + ".json").toString());
        File tempFile = null;
        PrintWriter printWriter = null;
        try {
            tempFile = File.createTempFile("temp", null, this.dir);
            tempFile.deleteOnExit();
            printWriter = new PrintWriter(tempFile);
            printWriter.println(json);
            printWriter.close();
            FileUtil.renameFile(tempFile, jsonFile);
        }
        catch (Throwable t2) {
            log.error("storageFile " + jsonFile.toString());
            t2.printStackTrace();
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                log.warn("Temp file still exists after failed save. We will delete it now. storageFile=" + fileName);
                if (!tempFile.delete()) {
                    log.error("Cannot delete temp file.");
                }
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

