/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.taskrunner;

import haveno.common.taskrunner.InterceptTaskException;
import haveno.common.taskrunner.Model;
import haveno.common.taskrunner.TaskRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task<T extends Model> {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    public static Class<? extends Task> taskToIntercept;
    protected final TaskRunner taskHandler;
    protected final T model;
    protected String errorMessage = "An error occurred at task: " + this.getClass().getSimpleName();
    protected boolean completed;

    public Task(TaskRunner taskHandler, T model) {
        this.taskHandler = taskHandler;
        this.model = model;
    }

    protected abstract void run();

    protected void runInterceptHook() {
        if (this.getClass() == taskToIntercept) {
            throw new InterceptTaskException("Task intercepted for testing purpose. Task = " + this.getClass().getSimpleName());
        }
    }

    protected void appendToErrorMessage(String message) {
        this.errorMessage = this.errorMessage + "\n" + message;
    }

    protected void appendExceptionToErrorMessage(Throwable t2) {
        this.errorMessage = t2.getMessage() != null ? this.errorMessage + "\nException message: " + t2.getMessage() : this.errorMessage + "\nException: " + t2.toString();
    }

    protected void complete() {
        this.completed = true;
        this.taskHandler.handleComplete();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    protected void failed(String message) {
        this.appendToErrorMessage(message);
        this.failed();
    }

    protected void failed(Throwable t2) {
        if (this.taskHandler.isCanceled()) {
            return;
        }
        this.errorMessage = t2.getMessage() + " (task " + this.getClass().getSimpleName() + ")";
        log.error(this.errorMessage, t2);
        this.taskHandler.handleErrorMessage(this.errorMessage);
    }

    protected void failed() {
        log.error(this.errorMessage);
        this.taskHandler.handleErrorMessage(this.errorMessage);
    }
}

