/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DesktopUtil {
    private static final Logger log = LoggerFactory.getLogger(DesktopUtil.class);

    DesktopUtil() {
    }

    public static boolean browse(URI uri) {
        return DesktopUtil.openSystemSpecific(uri.toString());
    }

    public static boolean open(File file) {
        return DesktopUtil.openSystemSpecific(file.getPath());
    }

    public static boolean edit(File file) {
        return DesktopUtil.openSystemSpecific(file.getPath());
    }

    private static boolean openSystemSpecific(String what) {
        EnumOS os = DesktopUtil.getOs();
        if (os.isLinux()) {
            if (DesktopUtil.runCommand("kde-open", "%s", what)) {
                return true;
            }
            if (DesktopUtil.runCommand("gnome-open", "%s", what)) {
                return true;
            }
            if (DesktopUtil.runCommand("xdg-open", "%s", what)) {
                return true;
            }
        }
        if (os.isMac() && DesktopUtil.runCommand("open", "%s", what)) {
            return true;
        }
        if (os.isWindows()) {
            return DesktopUtil.runCommand("explorer", "%s", "\"" + what + "\"");
        }
        return false;
    }

    private static boolean runCommand(String command, String args2, String file) {
        log.info("Trying to exec: cmd = {} args = {} file = {}", command, args2, file);
        String[] parts = DesktopUtil.prepareCommand(command, args2, file);
        try {
            Process p = Runtime.getRuntime().exec(parts);
            if (p == null) {
                return false;
            }
            try {
                int value = p.exitValue();
                if (value == 0) {
                    log.warn("Process ended immediately.");
                } else {
                    log.warn("Process crashed.");
                }
                return false;
            }
            catch (IllegalThreadStateException e) {
                log.info("Process is running.");
                return true;
            }
        }
        catch (IOException e) {
            log.warn("Error running command. {}", (Object)e.toString());
            return false;
        }
    }

    private static String[] prepareCommand(String command, String args2, String file) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(command);
        if (args2 != null) {
            for (String s2 : args2.split(" ")) {
                s2 = String.format(s2, file);
                parts.add(s2.trim());
            }
        }
        return parts.toArray(new String[parts.size()]);
    }

    private static EnumOS getOs() {
        String s2 = System.getProperty("os.name").toLowerCase();
        if (s2.contains("win")) {
            return EnumOS.windows;
        }
        if (s2.contains("mac")) {
            return EnumOS.macos;
        }
        if (s2.contains("solaris")) {
            return EnumOS.solaris;
        }
        if (s2.contains("sunos")) {
            return EnumOS.solaris;
        }
        if (s2.contains("linux")) {
            return EnumOS.linux;
        }
        if (s2.contains("unix")) {
            return EnumOS.linux;
        }
        return EnumOS.unknown;
    }

    public static enum EnumOS {
        linux,
        macos,
        solaris,
        unknown,
        windows;


        public boolean isLinux() {
            return this == linux || this == solaris;
        }

        public boolean isMac() {
            return this == macos;
        }

        public boolean isWindows() {
            return this == windows;
        }
    }
}

