/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.util;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtraDataMapValidator {
    private static final Logger log = LoggerFactory.getLogger(ExtraDataMapValidator.class);
    public static final int MAX_SIZE = 10;
    public static final int MAX_KEY_LENGTH = 100;
    public static final int MAX_VALUE_LENGTH = 100000;

    public static Map<String, String> getValidatedExtraDataMap(@Nullable Map<String, String> extraDataMap) {
        return ExtraDataMapValidator.getValidatedExtraDataMap(extraDataMap, 10, 100, 100000);
    }

    public static Map<String, String> getValidatedExtraDataMap(@Nullable Map<String, String> extraDataMap, int maxSize, int maxKeyLength, int maxValueLength) {
        if (extraDataMap == null) {
            return null;
        }
        try {
            Preconditions.checkArgument(extraDataMap.entrySet().size() <= maxSize, "Size of map must not exceed " + maxSize);
            extraDataMap.forEach((key, value) -> {
                Preconditions.checkArgument(key.length() <= maxKeyLength, "Length of key must not exceed " + maxKeyLength);
                Preconditions.checkArgument(value.length() <= maxValueLength, "Length of value must not exceed " + maxValueLength);
            });
            return extraDataMap;
        }
        catch (Throwable t2) {
            return new HashMap<String, String>();
        }
    }

    public static void validate(@Nullable Map<String, String> extraDataMap) {
        ExtraDataMapValidator.validate(extraDataMap, 10, 100, 100000);
    }

    public static void validate(@Nullable Map<String, String> extraDataMap, int maxSize, int maxKeyLength, int maxValueLength) {
        if (extraDataMap == null) {
            return;
        }
        Preconditions.checkArgument(extraDataMap.entrySet().size() <= maxSize, "Size of map must not exceed " + maxSize);
        extraDataMap.forEach((key, value) -> {
            Preconditions.checkArgument(key.length() <= maxKeyLength, "Length of key must not exceed " + maxKeyLength);
            Preconditions.checkArgument(value.length() <= maxValueLength, "Length of value must not exceed " + maxValueLength);
        });
    }
}

