/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.util;

import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MathUtils {
    private static final Logger log = LoggerFactory.getLogger(MathUtils.class);

    public static double roundDouble(double value, int precision) {
        return MathUtils.roundDouble(value, precision, RoundingMode.HALF_UP);
    }

    public static double roundDouble(double value, int precision, RoundingMode roundingMode) {
        if (precision < 0) {
            throw new IllegalArgumentException();
        }
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException("Expected a finite double, but found " + value);
        }
        try {
            BigDecimal bd = BigDecimal.valueOf(value);
            bd = bd.setScale(precision, roundingMode);
            return bd.doubleValue();
        }
        catch (Throwable t2) {
            log.error(t2.toString());
            return 0.0;
        }
    }

    public static long roundDoubleToLong(double value) {
        return MathUtils.roundDoubleToLong(value, RoundingMode.HALF_UP);
    }

    public static long roundDoubleToLong(double value, RoundingMode roundingMode) {
        return DoubleMath.roundToLong(value, roundingMode);
    }

    public static int roundDoubleToInt(double value) {
        return MathUtils.roundDoubleToInt(value, RoundingMode.HALF_UP);
    }

    public static int roundDoubleToInt(double value, RoundingMode roundingMode) {
        return DoubleMath.roundToInt(value, roundingMode);
    }

    public static long doubleToLong(double value) {
        return Double.valueOf(value).longValue();
    }

    public static double scaleUpByPowerOf10(double value, int exponent) {
        double factor = Math.pow(10.0, exponent);
        return value * factor;
    }

    public static double scaleUpByPowerOf10(long value, int exponent) {
        double factor = Math.pow(10.0, exponent);
        return (double)value * factor;
    }

    public static double scaleDownByPowerOf10(double value, int exponent) {
        double factor = Math.pow(10.0, exponent);
        return value / factor;
    }

    public static double scaleDownByPowerOf10(long value, int exponent) {
        double factor = Math.pow(10.0, exponent);
        return (double)value / factor;
    }

    public static double exactMultiply(double value1, double value2) {
        return BigDecimal.valueOf(value1).multiply(BigDecimal.valueOf(value2)).doubleValue();
    }

    public static long getMedian(Long[] list) {
        if (list.length == 0) {
            return 0L;
        }
        int middle = list.length / 2;
        long median = list.length % 2 == 1 ? list[middle] : MathUtils.roundDoubleToLong((double)(list[middle - 1] + list[middle]) / 2.0);
        return median;
    }

    public static class MovingAverage {
        final Deque<Long> window;
        private final int size;
        private long sum;
        private final double outlier;

        public MovingAverage(int size, double outlier) {
            this.size = size;
            this.window = new ArrayDeque<Long>(size);
            this.outlier = outlier;
            this.sum = 0L;
        }

        public Optional<Double> next(long val) {
            try {
                boolean fullAtStart = this.isFull();
                if (fullAtStart) {
                    if (this.outlier > 0.0) {
                        Preconditions.checkArgument(this.size != 0);
                        double avg = (double)this.sum / (double)this.size;
                        if (Math.abs(avg - (double)val) / avg > this.outlier) {
                            return Optional.empty();
                        }
                    }
                    this.sum -= this.window.remove().longValue();
                }
                this.window.add(val);
                this.sum += val;
                if (!fullAtStart && this.isFull() && this.outlier != 0.0) {
                    this.removeInitialOutlier();
                }
                return this.outlier > 0.0 && !this.isFull() ? Optional.empty() : this.current();
            }
            catch (Throwable t2) {
                log.error(t2.toString());
                return Optional.empty();
            }
        }

        boolean isFull() {
            return this.window.size() == this.size;
        }

        private void removeInitialOutlier() {
            Iterator<Long> element = this.window.iterator();
            while (element.hasNext()) {
                Long val = element.next();
                int div = this.size - 1;
                Preconditions.checkArgument(div != 0);
                double avgExVal = (double)(this.sum - val) / (double)div;
                if (!(Math.abs(avgExVal - (double)val.longValue()) / avgExVal > this.outlier)) continue;
                element.remove();
                break;
            }
        }

        public Optional<Double> current() {
            return this.window.size() == 0 ? Optional.empty() : Optional.of((double)this.sum / (double)this.window.size());
        }
    }
}

