/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.util;

import haveno.common.util.Profiler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermutationUtil {
    private static final Logger log = LoggerFactory.getLogger(PermutationUtil.class);

    public static <T> List<T> getPartialList(List<T> list, List<Integer> indicesToRemove) {
        ArrayList altered = new ArrayList(list);
        indicesToRemove = new ArrayList<Integer>(new HashSet<Integer>(indicesToRemove));
        Collections.sort(indicesToRemove);
        Collections.reverse(indicesToRemove);
        indicesToRemove.forEach(index -> {
            if (altered.size() > index && index >= 0) {
                altered.remove((int)index);
            }
        });
        return altered;
    }

    public static <T, R> List<T> findMatchingPermutation(R targetValue, List<T> list, BiPredicate<R, List<T>> predicate, int maxIterations) {
        if (predicate.test(targetValue, list)) {
            return list;
        }
        return PermutationUtil.findMatchingPermutation(targetValue, list, new ArrayList<List<T>>(), predicate, new AtomicInteger(maxIterations));
    }

    private static <T, R> List<T> findMatchingPermutation(R targetValue, List<T> list, List<List<T>> lists, BiPredicate<R, List<T>> predicate, AtomicInteger maxIterations) {
        for (int level = 0; level < list.size(); ++level) {
            List<T> result = PermutationUtil.checkLevel(targetValue, list, predicate, level, 0, maxIterations);
            if (result.isEmpty()) continue;
            return result;
        }
        return new ArrayList();
    }

    @NonNull
    private static <T, R> List<T> checkLevel(R targetValue, List<T> previousLevel, BiPredicate<R, List<T>> predicate, int level, int permutationIndex, AtomicInteger maxIterations) {
        if (previousLevel.size() == 1) {
            return new ArrayList();
        }
        for (int i = permutationIndex; i < previousLevel.size(); ++i) {
            if (maxIterations.get() <= 0) {
                return new ArrayList();
            }
            ArrayList<T> newList = new ArrayList<T>(previousLevel);
            newList.remove(i);
            if (level == 0) {
                maxIterations.decrementAndGet();
                if (!predicate.test(targetValue, newList)) continue;
                return newList;
            }
            List<T> result = PermutationUtil.checkLevel(targetValue, newList, predicate, level - 1, i, maxIterations);
            if (result.isEmpty()) continue;
            return result;
        }
        return new ArrayList();
    }

    public static <T> List<List<T>> findAllPermutations(List<T> list, int maxIterations) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int counter = 0;
        long ts = System.currentTimeMillis();
        for (T item : list) {
            if (++counter > maxIterations) {
                log.warn("We reached maxIterations of our allowed iterations and return current state of the result. counter={}", (Object)counter);
                return result;
            }
            ArrayList subLists = new ArrayList();
            for (int n = 0; n < result.size(); ++n) {
                if (++counter > maxIterations) {
                    log.warn("We reached maxIterations of our allowed iterations and return current state of the result. counter={}", (Object)counter);
                    return result;
                }
                ArrayList<T> subList = new ArrayList<T>((Collection)result.get(n));
                subList.add(item);
                subLists.add(subList);
            }
            result.add(new ArrayList<T>(Collections.singletonList(item)));
            result.addAll(subLists);
        }
        log.info("findAllPermutations took {} ms for {} items and {} iterations. Heap size used: {} MB", System.currentTimeMillis() - ts, list.size(), counter, Profiler.getUsedMemoryInMB());
        return result;
    }
}

