/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    public static void loadFieldListForClassHierarchy(List<Field> fields, Class<?> clazz, Predicate<Field> isExcludedField) {
        fields.addAll(Arrays.stream(clazz.getDeclaredFields()).filter(f -> !isExcludedField.test((Field)f)).collect(Collectors.toList()));
        Class<?> superclass = clazz.getSuperclass();
        if (!Objects.equals(superclass, Object.class)) {
            ReflectionUtils.loadFieldListForClassHierarchy(fields, superclass, isExcludedField);
        }
    }

    public static Optional<Method> getSetterMethodForFieldInClassHierarchy(Field field, Class<?> clazz) {
        Optional<Method> setter = Arrays.stream(clazz.getDeclaredMethods()).filter(m4 -> ReflectionUtils.isSetterForField(m4, field)).findFirst();
        if (setter.isPresent()) {
            return setter;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (!Objects.equals(superclass, Object.class) && (setter = ReflectionUtils.getSetterMethodForFieldInClassHierarchy(field, superclass)).isPresent()) {
            return setter;
        }
        return Optional.empty();
    }

    public static boolean isSetterForField(Method m4, Field f) {
        return m4.getName().startsWith("set") && m4.getName().endsWith(StringUtils.capitalize(f.getName())) && m4.getReturnType().getName().equals("void") && m4.getParameterCount() == 1 && m4.getParameterTypes()[0].getName().equals(f.getType().getName());
    }

    public static boolean isSetterOnClass(Method setter, Class<?> clazz) {
        return setter.getDeclaringClass().isAssignableFrom(clazz);
    }

    public static String getVisibilityModifierAsString(Field field) {
        if (Modifier.isPrivate(field.getModifiers())) {
            return "private";
        }
        if (Modifier.isProtected(field.getModifiers())) {
            return "protected";
        }
        if (Modifier.isPublic(field.getModifiers())) {
            return "public";
        }
        return "";
    }

    public static Field getField(String name, Class<?> clazz) {
        Optional<Field> field = Arrays.stream(clazz.getDeclaredFields()).filter(f -> f.getName().equals(name)).findFirst();
        return field.orElseThrow(() -> new IllegalArgumentException(String.format("field %s not found in class %s", name, clazz.getSimpleName())));
    }

    public static Method getMethod(String name, Class<?> clazz) {
        Optional<Method> method = Arrays.stream(clazz.getDeclaredMethods()).filter(m4 -> m4.getName().equals(name)).findFirst();
        return method.orElseThrow(() -> new IllegalArgumentException(String.format("method %s not found in class %s", name, clazz.getSimpleName())));
    }

    public static void handleSetFieldValueError(Object object, Field field, ReflectiveOperationException ex) {
        String errMsg = String.format("cannot set value of field %s, on class %s", field.getName(), object.getClass().getSimpleName());
        log.error(StringUtils.capitalize(errMsg) + ".", ex);
        throw new IllegalStateException("programmer error: " + errMsg);
    }
}

