/*
 * Decompiled with CFR 0.152.
 */
package haveno.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);

    public static void zipDirToStream(File dir, OutputStream out, int bufferSize, Collection<File> excludedFiles) throws Exception {
        ArrayList<File> fileList = new ArrayList<File>();
        ZipUtils.getFilesRecursive(dir, fileList, excludedFiles);
        try (ZipOutputStream zos = new ZipOutputStream(out);){
            for (File file : fileList) {
                String filePath = file.getAbsolutePath();
                log.info("Compressing: " + filePath);
                String name = filePath.substring(dir.getAbsolutePath().length() + 1);
                ZipEntry zipEntry = new ZipEntry(name);
                zos.putNextEntry(zipEntry);
                try (FileInputStream fis = new FileInputStream(filePath);){
                    int length;
                    byte[] buffer = new byte[bufferSize];
                    while ((length = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, length);
                    }
                    zos.closeEntry();
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                }
            }
        }
    }

    public static void getFilesRecursive(File directory, List<File> fileList, Collection<File> excludedFiles) {
        File[] files = directory.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (excludedFiles != null && excludedFiles.contains(file)) continue;
                if (file.isFile()) {
                    fileList.add(file);
                    continue;
                }
                ZipUtils.getFilesRecursive(file, fileList, excludedFiles);
            }
        }
    }

    public static void unzipToDir(File dir, InputStream inputStream, int bufferSize) throws Exception {
        try (ZipInputStream zipStream = new ZipInputStream(inputStream);){
            ZipEntry entry;
            byte[] buffer = new byte[bufferSize];
            while ((entry = zipStream.getNextEntry()) != null) {
                File file = new File(dir, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else {
                    file.getParentFile().mkdirs();
                    log.info("Unzipped file: " + file.getAbsolutePath());
                    if ("haveno.log".equals(file.getName())) {
                        file = new File(file.getParent() + "/haveno.backup.log");
                        log.info("Unzipped logfile to backup path: " + file.getAbsolutePath());
                    }
                    try (FileOutputStream fileOutput = new FileOutputStream(file);){
                        int count;
                        while ((count = zipStream.read(buffer)) != -1) {
                            fileOutput.write(buffer, 0, count);
                        }
                    }
                }
                zipStream.closeEntry();
            }
        }
    }
}

