/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.account.sign;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.persistence.PersistenceManager;
import haveno.core.account.sign.SignedWitness;
import haveno.core.account.sign.SignedWitnessStore;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.payload.PersistableNetworkPayload;
import haveno.network.p2p.storage.persistence.MapStoreService;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedWitnessStorageService
extends MapStoreService<SignedWitnessStore, PersistableNetworkPayload> {
    private static final Logger log = LoggerFactory.getLogger(SignedWitnessStorageService.class);
    private static final String FILE_NAME = "SignedWitnessStore";

    @Inject
    public SignedWitnessStorageService(@Named(value="storageDir") File storageDir, PersistenceManager<SignedWitnessStore> persistenceManager) {
        super(storageDir, persistenceManager);
    }

    @Override
    protected void initializePersistenceManager() {
        this.persistenceManager.initialize((SignedWitnessStore)this.store, PersistenceManager.Source.NETWORK);
    }

    @Override
    public String getFileName() {
        return FILE_NAME;
    }

    @Override
    public Map<P2PDataStorage.ByteArray, PersistableNetworkPayload> getMap() {
        return ((SignedWitnessStore)this.store).getMap();
    }

    @Override
    public boolean canHandle(PersistableNetworkPayload payload) {
        return payload instanceof SignedWitness;
    }

    @Override
    protected SignedWitnessStore createStore() {
        return new SignedWitnessStore();
    }
}

