/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.account.witness;

import com.google.protobuf.ByteString;
import haveno.common.util.Utilities;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.payload.DateTolerantPayload;
import haveno.network.p2p.storage.payload.PersistableNetworkPayload;
import haveno.network.p2p.storage.payload.ProcessOncePersistableNetworkPayload;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.AccountAgeWitness;

public final class AccountAgeWitness
implements ProcessOncePersistableNetworkPayload,
PersistableNetworkPayload,
DateTolerantPayload {
    private static final Logger log = LoggerFactory.getLogger(AccountAgeWitness.class);
    private static final long TOLERANCE = TimeUnit.DAYS.toMillis(1L);
    private final byte[] hash;
    private final long date;

    public AccountAgeWitness(byte[] hash, long date) {
        this.hash = hash;
        this.date = date;
    }

    @Override
    public protobuf.PersistableNetworkPayload toProtoMessage() {
        AccountAgeWitness.Builder builder = protobuf.AccountAgeWitness.newBuilder().setHash(ByteString.copyFrom(this.hash)).setDate(this.date);
        return protobuf.PersistableNetworkPayload.newBuilder().setAccountAgeWitness(builder).build();
    }

    public protobuf.AccountAgeWitness toProtoAccountAgeWitness() {
        return this.toProtoMessage().getAccountAgeWitness();
    }

    public static AccountAgeWitness fromProto(protobuf.AccountAgeWitness proto) {
        byte[] hash = proto.getHash().toByteArray();
        if (hash.length != 20) {
            log.warn("We got a a hash which is not 20 bytes");
            hash = new byte[]{};
        }
        return new AccountAgeWitness(hash, proto.getDate());
    }

    @Override
    public boolean isDateInTolerance(Clock clock) {
        return Math.abs(clock.millis() - this.date) <= TOLERANCE;
    }

    @Override
    public boolean verifyHashSize() {
        return this.hash.length == 20;
    }

    @Override
    public byte[] getHash() {
        return this.hash;
    }

    P2PDataStorage.ByteArray getHashAsByteArray() {
        return new P2PDataStorage.ByteArray(this.hash);
    }

    public String toString() {
        return "AccountAgeWitness{\n     hash=" + Utilities.bytesAsHexString(this.hash) + ",\n     date=" + String.valueOf(Instant.ofEpochMilli(this.date)) + "\n}";
    }

    public long getDate() {
        return this.date;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountAgeWitness)) {
            return false;
        }
        AccountAgeWitness other = (AccountAgeWitness)o;
        if (this.getDate() != other.getDate()) {
            return false;
        }
        return Arrays.equals(this.getHash(), other.getHash());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $date = this.getDate();
        result = result * 59 + (int)($date >>> 32 ^ $date);
        result = result * 59 + Arrays.hashCode(this.getHash());
        return result;
    }
}

