/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.alert;

import com.google.common.base.Charsets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.config.Config;
import haveno.common.crypto.KeyRing;
import haveno.core.alert.Alert;
import haveno.core.user.User;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.storage.HashMapChangedListener;
import haveno.network.p2p.storage.payload.ProtectedStorageEntry;
import haveno.network.p2p.storage.payload.ProtectedStoragePayload;
import java.math.BigInteger;
import java.security.SignatureException;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertManager {
    private static final Logger log = LoggerFactory.getLogger(AlertManager.class);
    private final P2PService p2PService;
    private final KeyRing keyRing;
    private final User user;
    private final ObjectProperty<Alert> alertMessageProperty = new SimpleObjectProperty<Alert>();
    private final boolean useDevPrivilegeKeys;
    private ECKey alertSigningKey;

    @Inject
    public AlertManager(P2PService p2PService, KeyRing keyRing, User user, @Named(value="ignoreDevMsg") boolean ignoreDevMsg, @Named(value="useDevPrivilegeKeys") boolean useDevPrivilegeKeys) {
        this.p2PService = p2PService;
        this.keyRing = keyRing;
        this.user = user;
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
        if (!ignoreDevMsg) {
            p2PService.addHashSetChangedListener(new HashMapChangedListener(){

                @Override
                public void onAdded(Collection<ProtectedStorageEntry> protectedStorageEntries) {
                    protectedStorageEntries.forEach(protectedStorageEntry -> {
                        Alert alert;
                        ProtectedStoragePayload protectedStoragePayload = protectedStorageEntry.getProtectedStoragePayload();
                        if (protectedStoragePayload instanceof Alert && AlertManager.this.verifySignature(alert = (Alert)protectedStoragePayload)) {
                            AlertManager.this.alertMessageProperty.set(alert);
                        }
                    });
                }

                @Override
                public void onRemoved(Collection<ProtectedStorageEntry> protectedStorageEntries) {
                    protectedStorageEntries.forEach(protectedStorageEntry -> {
                        ProtectedStoragePayload protectedStoragePayload = protectedStorageEntry.getProtectedStoragePayload();
                        if (protectedStoragePayload instanceof Alert && AlertManager.this.verifySignature((Alert)protectedStoragePayload)) {
                            AlertManager.this.alertMessageProperty.set(null);
                        }
                    });
                }
            });
        }
    }

    protected List<String> getPubKeyList() {
        if (this.useDevPrivilegeKeys) {
            return List.of("027a381b5333a56e1cc3d90d3a7d07f26509adf7029ed06fc997c656621f8da1ee");
        }
        switch (Config.baseCurrencyNetwork()) {
            case XMR_LOCAL: {
                return List.of("027a381b5333a56e1cc3d90d3a7d07f26509adf7029ed06fc997c656621f8da1ee", "024baabdba90e7cc0dc4626ef73ea9d722ea7085d1104491da8c76f28187513492");
            }
            case XMR_STAGENET: {
                return List.of("036d8a1dfcb406886037d2381da006358722823e1940acc2598c844bbc0fd1026f", "026c581ad773d987e6bd10785ac7f7e0e64864aedeb8bce5af37046de812a37854", "025b058c9f2c60d839669dbfa5578cf5a8117d60e6b70e2f0946f8a691273c6a36");
            }
            case XMR_MAINNET: {
                return List.of();
            }
        }
        throw new RuntimeException("Unhandled base currency network: " + String.valueOf((Object)Config.baseCurrencyNetwork()));
    }

    public ReadOnlyObjectProperty<Alert> alertMessageProperty() {
        return this.alertMessageProperty;
    }

    public boolean addAlertMessageIfKeyIsValid(Alert alert, String privKeyString) {
        boolean isKeyValid;
        if (this.user.getDevelopersAlert() != null) {
            this.removeAlertMessageIfKeyIsValid(privKeyString);
        }
        if (isKeyValid = this.isKeyValid(privKeyString)) {
            this.signAndAddSignatureToAlertMessage(alert);
            this.user.setDevelopersAlert(alert);
            boolean result = this.p2PService.addProtectedStorageEntry(alert);
            if (result) {
                log.trace("Add alertMessage to network was successful. AlertMessage={}", (Object)alert);
            }
        }
        return isKeyValid;
    }

    public boolean removeAlertMessageIfKeyIsValid(String privKeyString) {
        Alert alert = this.user.getDevelopersAlert();
        if (this.isKeyValid(privKeyString) && alert != null) {
            if (this.p2PService.removeData(alert)) {
                log.trace("Remove alertMessage from network was successful. AlertMessage={}", (Object)alert);
            }
            this.user.setDevelopersAlert(null);
            return true;
        }
        return false;
    }

    private boolean isKeyValid(String privKeyString) {
        try {
            this.alertSigningKey = ECKey.fromPrivate(new BigInteger(1, Utils.HEX.decode(privKeyString)));
            return this.getPubKeyList().contains(Utils.HEX.encode(this.alertSigningKey.getPubKey()));
        }
        catch (Throwable t2) {
            return false;
        }
    }

    private void signAndAddSignatureToAlertMessage(Alert alert) {
        String alertMessageAsHex = Utils.HEX.encode(alert.getMessage().getBytes(Charsets.UTF_8));
        String signatureAsBase64 = this.alertSigningKey.signMessage(alertMessageAsHex);
        alert.setSigAndPubKey(signatureAsBase64, this.keyRing.getSignatureKeyPair().getPublic());
    }

    private boolean verifySignature(Alert alert) {
        String alertMessageAsHex = Utils.HEX.encode(alert.getMessage().getBytes(Charsets.UTF_8));
        for (String pubKeyAsHex : this.getPubKeyList()) {
            try {
                ECKey.fromPublicOnly(Utils.HEX.decode(pubKeyAsHex)).verifyMessage(alertMessageAsHex, alert.getSignatureAsBase64());
                return true;
            }
            catch (SignatureException signatureException) {
            }
        }
        log.warn("verifySignature failed");
        return false;
    }
}

