/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.alert;

import com.google.common.base.Charsets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.config.Config;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.PubKeyRing;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.core.alert.PrivateNotificationMessage;
import haveno.core.alert.PrivateNotificationPayload;
import haveno.network.p2p.DecryptedMessageWithPubKey;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.SendMailboxMessageListener;
import haveno.network.p2p.mailbox.MailboxMessageService;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.peers.keepalive.messages.Ping;
import haveno.network.p2p.peers.keepalive.messages.Pong;
import java.math.BigInteger;
import java.security.SignatureException;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.Nullable;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Utils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateNotificationManager
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(PrivateNotificationManager.class);
    private final P2PService p2PService;
    private final MailboxMessageService mailboxMessageService;
    private final KeyRing keyRing;
    private final ObjectProperty<PrivateNotificationPayload> privateNotificationMessageProperty = new SimpleObjectProperty<PrivateNotificationPayload>();
    private final boolean useDevPrivilegeKeys;
    private ECKey privateNotificationSigningKey;
    @Nullable
    private PrivateNotificationMessage privateNotificationMessage;
    private final NetworkNode networkNode;
    private Consumer<String> pingResponseHandler = null;

    @Inject
    public PrivateNotificationManager(P2PService p2PService, NetworkNode networkNode, MailboxMessageService mailboxMessageService, KeyRing keyRing, @Named(value="ignoreDevMsg") boolean ignoreDevMsg, @Named(value="useDevPrivilegeKeys") boolean useDevPrivilegeKeys) {
        this.p2PService = p2PService;
        this.networkNode = networkNode;
        this.mailboxMessageService = mailboxMessageService;
        this.keyRing = keyRing;
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
        if (!ignoreDevMsg) {
            this.p2PService.addDecryptedDirectMessageListener(this::handleMessage);
            this.mailboxMessageService.addDecryptedMailboxListener(this::handleMessage);
        }
    }

    protected List<String> getPubKeyList() {
        if (this.useDevPrivilegeKeys) {
            return List.of("027a381b5333a56e1cc3d90d3a7d07f26509adf7029ed06fc997c656621f8da1ee");
        }
        switch (Config.baseCurrencyNetwork()) {
            case XMR_LOCAL: {
                return List.of("027a381b5333a56e1cc3d90d3a7d07f26509adf7029ed06fc997c656621f8da1ee", "024baabdba90e7cc0dc4626ef73ea9d722ea7085d1104491da8c76f28187513492");
            }
            case XMR_STAGENET: {
                return List.of("02ba7c5de295adfe57b60029f3637a2c6b1d0e969a8aaefb9e0ddc3a7963f26925", "026c581ad773d987e6bd10785ac7f7e0e64864aedeb8bce5af37046de812a37854", "025b058c9f2c60d839669dbfa5578cf5a8117d60e6b70e2f0946f8a691273c6a36");
            }
            case XMR_MAINNET: {
                return List.of();
            }
        }
        throw new RuntimeException("Unhandled base currency network: " + String.valueOf((Object)Config.baseCurrencyNetwork()));
    }

    private void handleMessage(DecryptedMessageWithPubKey decryptedMessageWithPubKey, NodeAddress senderNodeAddress) {
        NetworkEnvelope networkEnvelope = decryptedMessageWithPubKey.getNetworkEnvelope();
        if (networkEnvelope instanceof PrivateNotificationMessage) {
            this.privateNotificationMessage = (PrivateNotificationMessage)networkEnvelope;
            log.info("Received PrivateNotificationMessage from {} with uid={}", (Object)senderNodeAddress, (Object)this.privateNotificationMessage.getUid());
            if (this.privateNotificationMessage.getSenderNodeAddress().equals(senderNodeAddress)) {
                PrivateNotificationPayload privateNotification = this.privateNotificationMessage.getPrivateNotificationPayload();
                if (this.verifySignature(privateNotification)) {
                    this.privateNotificationMessageProperty.set(privateNotification);
                }
            } else {
                log.warn("Peer address not matching for privateNotificationMessage");
            }
        }
    }

    public ReadOnlyObjectProperty<PrivateNotificationPayload> privateNotificationProperty() {
        return this.privateNotificationMessageProperty;
    }

    public boolean sendPrivateNotificationMessageIfKeyIsValid(PrivateNotificationPayload privateNotification, PubKeyRing pubKeyRing, NodeAddress peersNodeAddress, String privKeyString, SendMailboxMessageListener sendMailboxMessageListener) {
        boolean isKeyValid = this.isKeyValid(privKeyString);
        if (isKeyValid) {
            this.signAndAddSignatureToPrivateNotificationMessage(privateNotification);
            PrivateNotificationMessage message = new PrivateNotificationMessage(privateNotification, this.p2PService.getNetworkNode().getNodeAddress(), UUID.randomUUID().toString());
            log.info("Send {} to peer {}. uid={}", message.getClass().getSimpleName(), peersNodeAddress, message.getUid());
            this.mailboxMessageService.sendEncryptedMailboxMessage(peersNodeAddress, pubKeyRing, message, sendMailboxMessageListener);
        }
        return isKeyValid;
    }

    public void removePrivateNotification() {
        if (this.privateNotificationMessage != null) {
            this.mailboxMessageService.removeMailboxMsg(this.privateNotificationMessage);
        }
    }

    private boolean isKeyValid(String privKeyString) {
        try {
            this.privateNotificationSigningKey = ECKey.fromPrivate(new BigInteger(1, Utils.HEX.decode(privKeyString)));
            return this.getPubKeyList().contains(Utils.HEX.encode(this.privateNotificationSigningKey.getPubKey()));
        }
        catch (Throwable t2) {
            return false;
        }
    }

    private void signAndAddSignatureToPrivateNotificationMessage(PrivateNotificationPayload privateNotification) {
        String privateNotificationMessageAsHex = Utils.HEX.encode(privateNotification.getMessage().getBytes(Charsets.UTF_8));
        String signatureAsBase64 = this.privateNotificationSigningKey.signMessage(privateNotificationMessageAsHex);
        privateNotification.setSigAndPubKey(signatureAsBase64, this.keyRing.getSignatureKeyPair().getPublic());
    }

    private boolean verifySignature(PrivateNotificationPayload privateNotification) {
        String privateNotificationMessageAsHex = Utils.HEX.encode(privateNotification.getMessage().getBytes(Charsets.UTF_8));
        for (String pubKeyAsHex : this.getPubKeyList()) {
            try {
                ECKey.fromPublicOnly(Utils.HEX.decode(pubKeyAsHex)).verifyMessage(privateNotificationMessageAsHex, privateNotification.getSignatureAsBase64());
                return true;
            }
            catch (SignatureException signatureException) {
            }
        }
        log.warn("verifySignature failed");
        return false;
    }

    public void sendPing(final NodeAddress peersNodeAddress, final Consumer<String> resultHandler) {
        final Ping ping = new Ping(new Random().nextInt(), 0);
        log.info("Send Ping to peer {}, nonce={}", (Object)peersNodeAddress, (Object)ping.getNonce());
        SettableFuture<Connection> future = this.networkNode.sendMessage(peersNodeAddress, (NetworkEnvelope)ping);
        Futures.addCallback(future, new FutureCallback<Connection>(){

            @Override
            public void onSuccess(Connection connection) {
                connection.addMessageListener(PrivateNotificationManager.this);
                PrivateNotificationManager.this.pingResponseHandler = resultHandler;
            }

            @Override
            public void onFailure(@NotNull Throwable throwable) {
                String errorMessage = "Sending ping to " + peersNodeAddress.getAddressForDisplay() + " failed. That is expected if the peer is offline.\n\tping=" + String.valueOf(ping) + ".\n\tException=" + throwable.getMessage();
                log.info(errorMessage);
                resultHandler.accept(errorMessage);
            }
        }, MoreExecutors.directExecutor());
    }

    @Override
    public void onMessage(NetworkEnvelope networkEnvelope, Connection connection) {
        if (networkEnvelope instanceof Pong) {
            Pong pong = (Pong)networkEnvelope;
            String key = connection.getPeersNodeAddressOptional().get().getFullAddress();
            log.info("Received Pong! {} from {}", (Object)pong, (Object)key);
            connection.removeMessageListener(this);
            if (this.pingResponseHandler != null) {
                this.pingResponseHandler.accept("SUCCESS");
            }
        }
    }
}

