/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.alert;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import haveno.common.crypto.Sig;
import haveno.common.proto.network.NetworkPayload;
import haveno.common.util.Utilities;
import java.security.PublicKey;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class PrivateNotificationPayload
implements NetworkPayload {
    private final String message;
    @Nullable
    private String signatureAsBase64;
    @Nullable
    private byte[] sigPublicKeyBytes;
    @Nullable
    private PublicKey sigPublicKey;

    public PrivateNotificationPayload(String message) {
        this.message = message;
    }

    private PrivateNotificationPayload(String message, String signatureAsBase64, byte[] sigPublicKeyBytes) {
        this(message);
        this.signatureAsBase64 = signatureAsBase64;
        this.sigPublicKeyBytes = sigPublicKeyBytes;
        this.sigPublicKey = Sig.getPublicKeyFromBytes(sigPublicKeyBytes);
    }

    public static PrivateNotificationPayload fromProto(protobuf.PrivateNotificationPayload proto) {
        return new PrivateNotificationPayload(proto.getMessage(), proto.getSignatureAsBase64(), proto.getSigPublicKeyBytes().toByteArray());
    }

    @Override
    public protobuf.PrivateNotificationPayload toProtoMessage() {
        Preconditions.checkNotNull(this.sigPublicKeyBytes, "sigPublicKeyBytes must not be null");
        Preconditions.checkNotNull(this.signatureAsBase64, "signatureAsBase64 must not be null");
        return protobuf.PrivateNotificationPayload.newBuilder().setMessage(this.message).setSignatureAsBase64(this.signatureAsBase64).setSigPublicKeyBytes(ByteString.copyFrom(this.sigPublicKeyBytes)).build();
    }

    public void setSigAndPubKey(String signatureAsBase64, PublicKey sigPublicKey) {
        this.signatureAsBase64 = signatureAsBase64;
        this.sigPublicKey = sigPublicKey;
        this.sigPublicKeyBytes = Sig.getPublicKeyBytes(sigPublicKey);
    }

    public String toString() {
        return "PrivateNotification{message='" + this.message + "', signatureAsBase64='" + this.signatureAsBase64 + "', publicKeyBytes=" + Utilities.bytesAsHexString(this.sigPublicKeyBytes) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrivateNotificationPayload)) {
            return false;
        }
        PrivateNotificationPayload other = (PrivateNotificationPayload)o;
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$signatureAsBase64 = this.getSignatureAsBase64();
        String other$signatureAsBase64 = other.getSignatureAsBase64();
        if (this$signatureAsBase64 == null ? other$signatureAsBase64 != null : !this$signatureAsBase64.equals(other$signatureAsBase64)) {
            return false;
        }
        if (!Arrays.equals(this.getSigPublicKeyBytes(), other.getSigPublicKeyBytes())) {
            return false;
        }
        PublicKey this$sigPublicKey = this.getSigPublicKey();
        PublicKey other$sigPublicKey = other.getSigPublicKey();
        return !(this$sigPublicKey == null ? other$sigPublicKey != null : !this$sigPublicKey.equals(other$sigPublicKey));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $signatureAsBase64 = this.getSignatureAsBase64();
        result = result * 59 + ($signatureAsBase64 == null ? 43 : $signatureAsBase64.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSigPublicKeyBytes());
        PublicKey $sigPublicKey = this.getSigPublicKey();
        result = result * 59 + ($sigPublicKey == null ? 43 : $sigPublicKey.hashCode());
        return result;
    }

    public String getMessage() {
        return this.message;
    }

    @Nullable
    public String getSignatureAsBase64() {
        return this.signatureAsBase64;
    }

    @Nullable
    public byte[] getSigPublicKeyBytes() {
        return this.sigPublicKeyBytes;
    }

    @Nullable
    public PublicKey getSigPublicKey() {
        return this.sigPublicKey;
    }
}

