/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.config.Config;
import haveno.common.crypto.KeyRing;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.arbitration.arbitrator.Arbitrator;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.support.dispute.mediation.mediator.Mediator;
import haveno.core.support.dispute.mediation.mediator.MediatorManager;
import haveno.core.support.dispute.refund.refundagent.RefundAgent;
import haveno.core.support.dispute.refund.refundagent.RefundAgentManager;
import haveno.core.user.User;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bitcoinj.core.ECKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class CoreDisputeAgentsService {
    private static final Logger log = LoggerFactory.getLogger(CoreDisputeAgentsService.class);
    private final User user;
    private final Config config;
    private final KeyRing keyRing;
    private final XmrWalletService xmrWalletService;
    private final ArbitratorManager arbitratorManager;
    private final MediatorManager mediatorManager;
    private final RefundAgentManager refundAgentManager;
    private final P2PService p2PService;
    private final NodeAddress nodeAddress;
    private final List<String> languageCodes;

    @Inject
    public CoreDisputeAgentsService(User user, Config config, KeyRing keyRing, XmrWalletService xmrWalletService, ArbitratorManager arbitratorManager, MediatorManager mediatorManager, RefundAgentManager refundAgentManager, P2PService p2PService) {
        this.user = user;
        this.config = config;
        this.keyRing = keyRing;
        this.xmrWalletService = xmrWalletService;
        this.arbitratorManager = arbitratorManager;
        this.mediatorManager = mediatorManager;
        this.refundAgentManager = refundAgentManager;
        this.p2PService = p2PService;
        this.nodeAddress = new NodeAddress(InetAddress.getLoopbackAddress().getHostName(), config.nodePort);
        this.languageCodes = Arrays.asList("de", "en", "es", "fr");
    }

    void registerDisputeAgent(String disputeAgentType, String registrationKey, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        if (!this.p2PService.isBootstrapped()) {
            throw new IllegalStateException("p2p service is not bootstrapped yet");
        }
        Optional<SupportType> supportType = this.getSupportType(disputeAgentType);
        if (supportType.isPresent()) {
            switch (supportType.get()) {
                case ARBITRATION: {
                    if (this.user.getRegisteredArbitrator() != null) {
                        log.warn("ignoring request to re-register as arbitrator");
                        resultHandler.handleResult();
                        return;
                    }
                    ECKey ecKey = this.arbitratorManager.getRegistrationKey(registrationKey);
                    if (ecKey == null) {
                        throw new IllegalStateException("invalid registration key");
                    }
                    String signature = this.arbitratorManager.signStorageSignaturePubKey(Objects.requireNonNull(ecKey));
                    this.registerArbitrator(this.nodeAddress, this.languageCodes, ecKey, signature, resultHandler, errorMessageHandler);
                    return;
                }
                case MEDIATION: {
                    if (this.user.getRegisteredMediator() != null) {
                        log.warn("ignoring request to re-register as mediator");
                        resultHandler.handleResult();
                        return;
                    }
                    ECKey ecKey = this.mediatorManager.getRegistrationKey(registrationKey);
                    if (ecKey == null) {
                        throw new IllegalStateException("invalid registration key");
                    }
                    String signature = this.mediatorManager.signStorageSignaturePubKey(Objects.requireNonNull(ecKey));
                    this.registerMediator(this.nodeAddress, this.languageCodes, ecKey, signature);
                    return;
                }
                case REFUND: {
                    if (this.user.getRegisteredRefundAgent() != null) {
                        log.warn("ignoring request to re-register as refund agent");
                        resultHandler.handleResult();
                        return;
                    }
                    ECKey ecKey = this.refundAgentManager.getRegistrationKey(registrationKey);
                    if (ecKey == null) {
                        throw new IllegalStateException("invalid registration key");
                    }
                    String signature = this.refundAgentManager.signStorageSignaturePubKey(Objects.requireNonNull(ecKey));
                    this.registerRefundAgent(this.nodeAddress, this.languageCodes, ecKey, signature);
                    return;
                }
                case TRADE: {
                    throw new IllegalArgumentException("trade agent registration not supported");
                }
            }
        } else {
            throw new IllegalArgumentException(String.format("unknown dispute agent type '%s'", disputeAgentType));
        }
    }

    void unregisterDisputeAgent(String disputeAgentType, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        if (!this.p2PService.isBootstrapped()) {
            throw new IllegalStateException("p2p service is not bootstrapped yet");
        }
        Optional<SupportType> supportType = this.getSupportType(disputeAgentType);
        if (supportType.isPresent()) {
            switch (supportType.get()) {
                case ARBITRATION: {
                    if (this.user.getRegisteredArbitrator() == null) {
                        errorMessageHandler.handleErrorMessage("User is not arbitrator");
                        return;
                    }
                    this.unregisterDisputeAgent(resultHandler, errorMessageHandler);
                    return;
                }
                case MEDIATION: {
                    throw new IllegalStateException("unregister mediator not implemented");
                }
                case REFUND: {
                    throw new IllegalStateException("unregister refund agent not implemented");
                }
                case TRADE: {
                    throw new IllegalArgumentException("trade agent registration not supported");
                }
            }
        } else {
            throw new IllegalArgumentException(String.format("unknown dispute agent type '%s'", disputeAgentType));
        }
    }

    private void registerArbitrator(NodeAddress nodeAddress, List<String> languageCodes, ECKey ecKey, String signature, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        Arbitrator arbitrator = new Arbitrator(this.p2PService.getAddress(), this.keyRing.getPubKeyRing(), new ArrayList<String>(languageCodes), new Date().getTime(), ecKey.getPubKey(), signature, "", null, null);
        this.arbitratorManager.addDisputeAgent(arbitrator, () -> {
            if (!this.arbitratorManager.getDisputeAgentByNodeAddress(nodeAddress).isPresent()) {
                errorMessageHandler.handleErrorMessage("could not register arbitrator");
            } else {
                resultHandler.handleResult();
            }
        }, errorMessageHandler);
    }

    private void registerMediator(NodeAddress nodeAddress, List<String> languageCodes, ECKey ecKey, String signature) {
        Mediator mediator = new Mediator(nodeAddress, this.keyRing.getPubKeyRing(), new ArrayList<String>(languageCodes), new Date().getTime(), ecKey.getPubKey(), signature, null, null, null);
        this.mediatorManager.addDisputeAgent(mediator, () -> {}, errorMessage -> {});
        this.mediatorManager.getDisputeAgentByNodeAddress(nodeAddress).orElseThrow(() -> new IllegalStateException("could not register mediator"));
    }

    private void registerRefundAgent(NodeAddress nodeAddress, List<String> languageCodes, ECKey ecKey, String signature) {
        RefundAgent refundAgent = new RefundAgent(nodeAddress, this.keyRing.getPubKeyRing(), new ArrayList<String>(languageCodes), new Date().getTime(), ecKey.getPubKey(), signature, null, null, null);
        this.refundAgentManager.addDisputeAgent(refundAgent, () -> {}, errorMessage -> {});
        this.refundAgentManager.getDisputeAgentByNodeAddress(nodeAddress).orElseThrow(() -> new IllegalStateException("could not register refund agent"));
    }

    private Optional<SupportType> getSupportType(String disputeAgentType) {
        switch (disputeAgentType.toLowerCase()) {
            case "arbitrator": {
                return Optional.of(SupportType.ARBITRATION);
            }
            case "mediator": {
                return Optional.of(SupportType.MEDIATION);
            }
            case "refundagent": 
            case "refund_agent": {
                return Optional.of(SupportType.REFUND);
            }
            case "tradeagent": 
            case "trade_agent": {
                return Optional.of(SupportType.TRADE);
            }
        }
        return Optional.empty();
    }

    private void unregisterDisputeAgent(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.arbitratorManager.removeDisputeAgent(resultHandler, errorMesage -> errorMessageHandler.handleErrorMessage("Error unregistering dispute agent: " + errorMesage));
    }
}

