/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api;

import com.google.inject.Singleton;
import haveno.core.api.NotificationListener;
import haveno.core.api.model.TradeInfo;
import haveno.core.support.messages.ChatMessage;
import haveno.core.trade.BuyerTrade;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.MakerTrade;
import haveno.core.trade.SellerTrade;
import haveno.core.trade.Trade;
import haveno.proto.grpc.NotificationMessage;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CoreNotificationService {
    private static final Logger log = LoggerFactory.getLogger(CoreNotificationService.class);
    private final Object lock = new Object();
    private final List<NotificationListener> listeners = new LinkedList<NotificationListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NonNull NotificationListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(@NonNull NotificationMessage notification) {
        if (notification == null) {
            throw new NullPointerException("notification is marked non-null but is null");
        }
        Object object = this.lock;
        synchronized (object) {
            Iterator<NotificationListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                NotificationListener listener = iter.next();
                try {
                    listener.onMessage(notification);
                }
                catch (RuntimeException e) {
                    log.warn("Failed to send notification to listener {}: {}", (Object)listener, (Object)e.getMessage());
                    iter.remove();
                }
            }
        }
    }

    public void sendAppInitializedNotification() {
        this.sendNotification(NotificationMessage.newBuilder().setType(NotificationMessage.NotificationType.APP_INITIALIZED).setTimestamp(System.currentTimeMillis()).build());
    }

    public void sendTradeNotification(Trade trade, Trade.Phase phase, String title, String message) {
        if (trade instanceof MakerTrade && phase == Trade.Phase.DEPOSITS_PUBLISHED) {
            HavenoUtils.playChimeSound();
        }
        if (trade instanceof BuyerTrade && phase == Trade.Phase.DEPOSITS_UNLOCKED) {
            HavenoUtils.playChimeSound();
        }
        if (trade instanceof SellerTrade && phase == Trade.Phase.PAYMENT_SENT) {
            HavenoUtils.playChimeSound();
        }
        this.sendNotification(NotificationMessage.newBuilder().setType(NotificationMessage.NotificationType.TRADE_UPDATE).setTrade(TradeInfo.toTradeInfo(trade).toProtoMessage()).setTimestamp(System.currentTimeMillis()).setTitle(title).setMessage(message).build());
    }

    public void sendChatNotification(ChatMessage chatMessage) {
        HavenoUtils.playChimeSound();
        this.sendNotification(NotificationMessage.newBuilder().setType(NotificationMessage.NotificationType.CHAT_MESSAGE).setTimestamp(System.currentTimeMillis()).setChatMessage(chatMessage.toProtoNetworkEnvelope().getChatMessage()).build());
    }

    public void sendErrorNotification(String title, String errorMessage) {
        this.sendNotification(NotificationMessage.newBuilder().setType(NotificationMessage.NotificationType.ERROR).setTimestamp(System.currentTimeMillis()).setTitle(title).setMessage(errorMessage == null ? "null" : errorMessage).build());
    }
}

