/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api.model;

import haveno.common.Payload;
import haveno.core.proto.CoreProtoResolver;
import haveno.proto.grpc.ContractInfo;
import java.util.function.Supplier;
import protobuf.PaymentAccountPayload;

public class ContractInfo
implements Payload {
    private final String buyerNodeAddress;
    private final String sellerNodeAddress;
    private final String arbitratorNodeAddress;
    private final boolean isBuyerMakerAndSellerTaker;
    private final String makerAccountId;
    private final String takerAccountId;
    private final haveno.core.payment.payload.PaymentAccountPayload makerPaymentAccountPayload;
    private final haveno.core.payment.payload.PaymentAccountPayload takerPaymentAccountPayload;
    private final String makerPayoutAddressString;
    private final String takerPayoutAddressString;
    public static Supplier<ContractInfo> emptyContract = () -> new ContractInfo("", "", "", false, "", "", null, null, "", "");

    public ContractInfo(String buyerNodeAddress, String sellerNodeAddress, String arbitratorNodeAddress, boolean isBuyerMakerAndSellerTaker, String makerAccountId, String takerAccountId, haveno.core.payment.payload.PaymentAccountPayload makerPaymentAccountPayload, haveno.core.payment.payload.PaymentAccountPayload takerPaymentAccountPayload, String makerPayoutAddressString, String takerPayoutAddressString) {
        this.buyerNodeAddress = buyerNodeAddress;
        this.sellerNodeAddress = sellerNodeAddress;
        this.arbitratorNodeAddress = arbitratorNodeAddress;
        this.isBuyerMakerAndSellerTaker = isBuyerMakerAndSellerTaker;
        this.makerAccountId = makerAccountId;
        this.takerAccountId = takerAccountId;
        this.makerPaymentAccountPayload = makerPaymentAccountPayload;
        this.takerPaymentAccountPayload = takerPaymentAccountPayload;
        this.makerPayoutAddressString = makerPayoutAddressString;
        this.takerPayoutAddressString = takerPayoutAddressString;
    }

    public static ContractInfo fromProto(haveno.proto.grpc.ContractInfo proto) {
        CoreProtoResolver coreProtoResolver = new CoreProtoResolver();
        return new ContractInfo(proto.getBuyerNodeAddress(), proto.getSellerNodeAddress(), proto.getArbitratorNodeAddress(), proto.getIsBuyerMakerAndSellerTaker(), proto.getMakerAccountId(), proto.getTakerAccountId(), proto.getMakerPaymentAccountPayload() == null ? null : haveno.core.payment.payload.PaymentAccountPayload.fromProto(proto.getMakerPaymentAccountPayload(), coreProtoResolver), proto.getTakerPaymentAccountPayload() == null ? null : haveno.core.payment.payload.PaymentAccountPayload.fromProto(proto.getTakerPaymentAccountPayload(), coreProtoResolver), proto.getMakerPayoutAddressString(), proto.getTakerPayoutAddressString());
    }

    @Override
    public haveno.proto.grpc.ContractInfo toProtoMessage() {
        ContractInfo.Builder builder = haveno.proto.grpc.ContractInfo.newBuilder().setBuyerNodeAddress(this.buyerNodeAddress).setSellerNodeAddress(this.sellerNodeAddress).setArbitratorNodeAddress(this.arbitratorNodeAddress).setIsBuyerMakerAndSellerTaker(this.isBuyerMakerAndSellerTaker).setMakerAccountId(this.makerAccountId).setTakerAccountId(this.takerAccountId).setMakerPayoutAddressString(this.makerPayoutAddressString).setTakerPayoutAddressString(this.takerPayoutAddressString);
        if (this.makerPaymentAccountPayload != null) {
            builder.setMakerPaymentAccountPayload((PaymentAccountPayload)this.makerPaymentAccountPayload.toProtoMessage());
        }
        if (this.takerPaymentAccountPayload != null) {
            builder.setTakerPaymentAccountPayload((PaymentAccountPayload)this.takerPaymentAccountPayload.toProtoMessage());
        }
        return builder.build();
    }

    public String getBuyerNodeAddress() {
        return this.buyerNodeAddress;
    }

    public String getSellerNodeAddress() {
        return this.sellerNodeAddress;
    }

    public String getArbitratorNodeAddress() {
        return this.arbitratorNodeAddress;
    }

    public boolean isBuyerMakerAndSellerTaker() {
        return this.isBuyerMakerAndSellerTaker;
    }

    public String getMakerAccountId() {
        return this.makerAccountId;
    }

    public String getTakerAccountId() {
        return this.takerAccountId;
    }

    public haveno.core.payment.payload.PaymentAccountPayload getMakerPaymentAccountPayload() {
        return this.makerPaymentAccountPayload;
    }

    public haveno.core.payment.payload.PaymentAccountPayload getTakerPaymentAccountPayload() {
        return this.takerPaymentAccountPayload;
    }

    public String getMakerPayoutAddressString() {
        return this.makerPayoutAddressString;
    }

    public String getTakerPayoutAddressString() {
        return this.takerPayoutAddressString;
    }
}

