/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api.model;

import haveno.common.proto.ProtoUtil;
import haveno.common.proto.persistable.PersistablePayload;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import protobuf.Country;
import protobuf.PaymentAccountFormField;
import protobuf.TradeCurrency;

@Immutable
public final class PaymentAccountFormField
implements PersistablePayload {
    private FieldId id;
    private Component component;
    @Nullable
    private String type;
    private String label;
    private String value;
    private int minLength;
    private int maxLength;
    private List<haveno.core.locale.TradeCurrency> supportedCurrencies;
    private List<haveno.core.locale.Country> supportedCountries;
    private List<haveno.core.locale.Country> supportedSepaEuroCountries;
    private List<haveno.core.locale.Country> supportedSepaNonEuroCountries;
    private List<String> requiredForCountries;

    public PaymentAccountFormField(FieldId id) {
        this.id = id;
    }

    @Override
    public protobuf.PaymentAccountFormField toProtoMessage() {
        PaymentAccountFormField.Builder builder = protobuf.PaymentAccountFormField.newBuilder().setId(FieldId.toProtoMessage(this.id)).setComponent(Component.toProtoMessage(this.component)).setMinLength(this.minLength).setMaxLength(this.maxLength);
        Optional.ofNullable(this.type).ifPresent(builder::setType);
        Optional.ofNullable(this.label).ifPresent(builder::setLabel);
        Optional.ofNullable(this.value).ifPresent(builder::setValue);
        Optional.ofNullable(this.supportedCurrencies).ifPresent(e -> builder.addAllSupportedCurrencies(ProtoUtil.collectionToProto(this.supportedCurrencies, TradeCurrency.class)));
        Optional.ofNullable(this.supportedCountries).ifPresent(e -> builder.addAllSupportedCountries(ProtoUtil.collectionToProto(this.supportedCountries, Country.class)));
        Optional.ofNullable(this.supportedSepaEuroCountries).ifPresent(e -> builder.addAllSupportedSepaEuroCountries(ProtoUtil.collectionToProto(this.supportedSepaEuroCountries, Country.class)));
        Optional.ofNullable(this.supportedSepaNonEuroCountries).ifPresent(e -> builder.addAllSupportedSepaNonEuroCountries(ProtoUtil.collectionToProto(this.supportedSepaNonEuroCountries, Country.class)));
        Optional.ofNullable(this.requiredForCountries).ifPresent(builder::addAllRequiredForCountries);
        return builder.build();
    }

    public static PaymentAccountFormField fromProto(protobuf.PaymentAccountFormField proto) {
        PaymentAccountFormField formField = new PaymentAccountFormField(FieldId.fromProto(proto.getId()));
        formField.type = proto.getType();
        formField.label = proto.getLabel();
        formField.value = proto.getValue();
        formField.minLength = proto.getMinLength();
        formField.maxLength = proto.getMaxLength();
        formField.supportedCountries = proto.getSupportedCountriesList().isEmpty() ? null : proto.getSupportedCountriesList().stream().map(haveno.core.locale.Country::fromProto).collect(Collectors.toList());
        formField.supportedSepaEuroCountries = proto.getSupportedSepaEuroCountriesList().isEmpty() ? null : proto.getSupportedSepaEuroCountriesList().stream().map(haveno.core.locale.Country::fromProto).collect(Collectors.toList());
        formField.supportedSepaNonEuroCountries = proto.getSupportedSepaNonEuroCountriesList().isEmpty() ? null : proto.getSupportedSepaNonEuroCountriesList().stream().map(haveno.core.locale.Country::fromProto).collect(Collectors.toList());
        formField.requiredForCountries = proto.getRequiredForCountriesList() == null ? null : new ArrayList<String>(proto.getRequiredForCountriesList());
        return formField;
    }

    public FieldId getId() {
        return this.id;
    }

    public Component getComponent() {
        return this.component;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getValue() {
        return this.value;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public List<haveno.core.locale.TradeCurrency> getSupportedCurrencies() {
        return this.supportedCurrencies;
    }

    public List<haveno.core.locale.Country> getSupportedCountries() {
        return this.supportedCountries;
    }

    public List<haveno.core.locale.Country> getSupportedSepaEuroCountries() {
        return this.supportedSepaEuroCountries;
    }

    public List<haveno.core.locale.Country> getSupportedSepaNonEuroCountries() {
        return this.supportedSepaNonEuroCountries;
    }

    public List<String> getRequiredForCountries() {
        return this.requiredForCountries;
    }

    public void setId(FieldId id) {
        this.id = id;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setSupportedCurrencies(List<haveno.core.locale.TradeCurrency> supportedCurrencies) {
        this.supportedCurrencies = supportedCurrencies;
    }

    public void setSupportedCountries(List<haveno.core.locale.Country> supportedCountries) {
        this.supportedCountries = supportedCountries;
    }

    public void setSupportedSepaEuroCountries(List<haveno.core.locale.Country> supportedSepaEuroCountries) {
        this.supportedSepaEuroCountries = supportedSepaEuroCountries;
    }

    public void setSupportedSepaNonEuroCountries(List<haveno.core.locale.Country> supportedSepaNonEuroCountries) {
        this.supportedSepaNonEuroCountries = supportedSepaNonEuroCountries;
    }

    public void setRequiredForCountries(List<String> requiredForCountries) {
        this.requiredForCountries = requiredForCountries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentAccountFormField)) {
            return false;
        }
        PaymentAccountFormField other = (PaymentAccountFormField)o;
        if (this.getMinLength() != other.getMinLength()) {
            return false;
        }
        if (this.getMaxLength() != other.getMaxLength()) {
            return false;
        }
        FieldId this$id = this.getId();
        FieldId other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)((Object)this$id)).equals((Object)other$id)) {
            return false;
        }
        Component this$component = this.getComponent();
        Component other$component = other.getComponent();
        if (this$component == null ? other$component != null : !((Object)((Object)this$component)).equals((Object)other$component)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<haveno.core.locale.TradeCurrency> this$supportedCurrencies = this.getSupportedCurrencies();
        List<haveno.core.locale.TradeCurrency> other$supportedCurrencies = other.getSupportedCurrencies();
        if (this$supportedCurrencies == null ? other$supportedCurrencies != null : !((Object)this$supportedCurrencies).equals(other$supportedCurrencies)) {
            return false;
        }
        List<haveno.core.locale.Country> this$supportedCountries = this.getSupportedCountries();
        List<haveno.core.locale.Country> other$supportedCountries = other.getSupportedCountries();
        if (this$supportedCountries == null ? other$supportedCountries != null : !((Object)this$supportedCountries).equals(other$supportedCountries)) {
            return false;
        }
        List<haveno.core.locale.Country> this$supportedSepaEuroCountries = this.getSupportedSepaEuroCountries();
        List<haveno.core.locale.Country> other$supportedSepaEuroCountries = other.getSupportedSepaEuroCountries();
        if (this$supportedSepaEuroCountries == null ? other$supportedSepaEuroCountries != null : !((Object)this$supportedSepaEuroCountries).equals(other$supportedSepaEuroCountries)) {
            return false;
        }
        List<haveno.core.locale.Country> this$supportedSepaNonEuroCountries = this.getSupportedSepaNonEuroCountries();
        List<haveno.core.locale.Country> other$supportedSepaNonEuroCountries = other.getSupportedSepaNonEuroCountries();
        if (this$supportedSepaNonEuroCountries == null ? other$supportedSepaNonEuroCountries != null : !((Object)this$supportedSepaNonEuroCountries).equals(other$supportedSepaNonEuroCountries)) {
            return false;
        }
        List<String> this$requiredForCountries = this.getRequiredForCountries();
        List<String> other$requiredForCountries = other.getRequiredForCountries();
        return !(this$requiredForCountries == null ? other$requiredForCountries != null : !((Object)this$requiredForCountries).equals(other$requiredForCountries));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinLength();
        result = result * 59 + this.getMaxLength();
        FieldId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)((Object)$id)).hashCode());
        Component $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : ((Object)((Object)$component)).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<haveno.core.locale.TradeCurrency> $supportedCurrencies = this.getSupportedCurrencies();
        result = result * 59 + ($supportedCurrencies == null ? 43 : ((Object)$supportedCurrencies).hashCode());
        List<haveno.core.locale.Country> $supportedCountries = this.getSupportedCountries();
        result = result * 59 + ($supportedCountries == null ? 43 : ((Object)$supportedCountries).hashCode());
        List<haveno.core.locale.Country> $supportedSepaEuroCountries = this.getSupportedSepaEuroCountries();
        result = result * 59 + ($supportedSepaEuroCountries == null ? 43 : ((Object)$supportedSepaEuroCountries).hashCode());
        List<haveno.core.locale.Country> $supportedSepaNonEuroCountries = this.getSupportedSepaNonEuroCountries();
        result = result * 59 + ($supportedSepaNonEuroCountries == null ? 43 : ((Object)$supportedSepaNonEuroCountries).hashCode());
        List<String> $requiredForCountries = this.getRequiredForCountries();
        result = result * 59 + ($requiredForCountries == null ? 43 : ((Object)$requiredForCountries).hashCode());
        return result;
    }

    public String toString() {
        return "PaymentAccountFormField(id=" + String.valueOf((Object)this.getId()) + ", component=" + String.valueOf((Object)this.getComponent()) + ", type=" + this.getType() + ", label=" + this.getLabel() + ", value=" + this.getValue() + ", minLength=" + this.getMinLength() + ", maxLength=" + this.getMaxLength() + ", supportedCurrencies=" + String.valueOf(this.getSupportedCurrencies()) + ", supportedCountries=" + String.valueOf(this.getSupportedCountries()) + ", supportedSepaEuroCountries=" + String.valueOf(this.getSupportedSepaEuroCountries()) + ", supportedSepaNonEuroCountries=" + String.valueOf(this.getSupportedSepaNonEuroCountries()) + ", requiredForCountries=" + String.valueOf(this.getRequiredForCountries()) + ")";
    }

    public static enum FieldId {
        ADDRESS,
        ACCEPTED_COUNTRY_CODES,
        ACCOUNT_ID,
        ACCOUNT_NAME,
        ACCOUNT_NR,
        ACCOUNT_OWNER,
        ACCOUNT_TYPE,
        ANSWER,
        BANK_ACCOUNT_NAME,
        BANK_ACCOUNT_NUMBER,
        BANK_ACCOUNT_TYPE,
        BANK_ADDRESS,
        BANK_BRANCH,
        BANK_BRANCH_CODE,
        BANK_BRANCH_NAME,
        BANK_CODE,
        BANK_COUNTRY_CODE,
        BANK_ID,
        BANK_NAME,
        BANK_SWIFT_CODE,
        BENEFICIARY_ACCOUNT_NR,
        BENEFICIARY_ADDRESS,
        BENEFICIARY_CITY,
        BENEFICIARY_NAME,
        BENEFICIARY_PHONE,
        BIC,
        BRANCH_ID,
        CITY,
        CONTACT,
        COUNTRY,
        EMAIL,
        EMAIL_OR_MOBILE_NR,
        EXTRA_INFO,
        HOLDER_ADDRESS,
        HOLDER_EMAIL,
        HOLDER_NAME,
        HOLDER_TAX_ID,
        IBAN,
        IFSC,
        INTERMEDIARY_ADDRESS,
        INTERMEDIARY_BRANCH,
        INTERMEDIARY_COUNTRY_CODE,
        INTERMEDIARY_NAME,
        INTERMEDIARY_SWIFT_CODE,
        MOBILE_NR,
        NATIONAL_ACCOUNT_ID,
        PAYID,
        PIX_KEY,
        POSTAL_ADDRESS,
        PROMPT_PAY_ID,
        QUESTION,
        REQUIREMENTS,
        SALT,
        SORT_CODE,
        SPECIAL_INSTRUCTIONS,
        STATE,
        TRADE_CURRENCIES,
        USERNAME,
        EMAIL_OR_MOBILE_NR_OR_USERNAME,
        EMAIL_OR_MOBILE_NR_OR_CASHTAG;


        public static FieldId fromProto(PaymentAccountFormField.FieldId fieldId) {
            return ProtoUtil.enumFromProto(FieldId.class, fieldId.name());
        }

        public static PaymentAccountFormField.FieldId toProtoMessage(FieldId fieldId) {
            return PaymentAccountFormField.FieldId.valueOf(fieldId.name());
        }
    }

    public static enum Component {
        TEXT,
        TEXTAREA,
        SELECT_ONE,
        SELECT_MULTIPLE;


        public static Component fromProto(PaymentAccountFormField.Component component) {
            return ProtoUtil.enumFromProto(Component.class, component.name());
        }

        public static PaymentAccountFormField.Component toProtoMessage(Component component) {
            return PaymentAccountFormField.Component.valueOf(component.name());
        }
    }
}

