/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api.model;

import haveno.common.Payload;
import haveno.core.api.model.ContractInfo;
import haveno.core.api.model.OfferInfo;
import haveno.core.api.model.builder.TradeInfoV1Builder;
import haveno.core.trade.Contract;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeUtil;
import haveno.core.util.PriceUtil;
import haveno.core.util.VolumeUtil;
import java.util.Objects;
import java.util.function.Function;

public class TradeInfo
implements Payload {
    private static final Function<Trade, String> toPeerNodeAddress = trade -> trade.getTradePeerNodeAddress() == null ? "" : trade.getTradePeerNodeAddress().getFullAddress();
    private static final Function<Trade, String> toArbitratorNodeAddress = trade -> trade.getArbitratorNodeAddress() == null ? "" : trade.getArbitratorNodeAddress().getFullAddress();
    private static final Function<Trade, String> toRoundedVolume = trade -> trade.getVolume() == null ? "" : VolumeUtil.formatVolume(Objects.requireNonNull(trade.getVolume()));
    private static final Function<Trade, String> toPreciseTradePrice = trade -> PriceUtil.reformatMarketPrice(Objects.requireNonNull(trade.getPrice()).toPlainString(), trade.getOffer().getCurrencyCode());
    private final OfferInfo offer;
    private final String tradeId;
    private final String shortId;
    private final long date;
    private final String role;
    private final String makerDepositTxId;
    private final String takerDepositTxId;
    private final String payoutTxId;
    private final long amount;
    private final long makerFee;
    private final long takerFee;
    private final long buyerSecurityDeposit;
    private final long sellerSecurityDeposit;
    private final long buyerDepositTxFee;
    private final long sellerDepositTxFee;
    private final long buyerPayoutTxFee;
    private final long sellerPayoutTxFee;
    private final long buyerPayoutAmount;
    private final long sellerPayoutAmount;
    private final String price;
    private final String volume;
    private final String arbitratorNodeAddress;
    private final String tradePeerNodeAddress;
    private final String state;
    private final String phase;
    private final String periodState;
    private final String payoutState;
    private final String disputeState;
    private final boolean isDepositsPublished;
    private final boolean isDepositsConfirmed;
    private final boolean isDepositsUnlocked;
    private final boolean isPaymentSent;
    private final boolean isPaymentReceived;
    private final boolean isPayoutPublished;
    private final boolean isPayoutConfirmed;
    private final boolean isPayoutUnlocked;
    private final boolean isCompleted;
    private final String contractAsJson;
    private final ContractInfo contract;

    public TradeInfo(TradeInfoV1Builder builder) {
        this.offer = builder.getOffer();
        this.tradeId = builder.getTradeId();
        this.shortId = builder.getShortId();
        this.date = builder.getDate();
        this.role = builder.getRole();
        this.makerDepositTxId = builder.getMakerDepositTxId();
        this.takerDepositTxId = builder.getTakerDepositTxId();
        this.payoutTxId = builder.getPayoutTxId();
        this.amount = builder.getAmount();
        this.makerFee = builder.getMakerFee();
        this.takerFee = builder.getTakerFee();
        this.buyerSecurityDeposit = builder.getBuyerSecurityDeposit();
        this.sellerSecurityDeposit = builder.getSellerSecurityDeposit();
        this.buyerDepositTxFee = builder.getBuyerDepositTxFee();
        this.sellerDepositTxFee = builder.getSellerDepositTxFee();
        this.buyerPayoutTxFee = builder.getBuyerPayoutTxFee();
        this.sellerPayoutTxFee = builder.getSellerPayoutTxFee();
        this.buyerPayoutAmount = builder.getBuyerPayoutAmount();
        this.sellerPayoutAmount = builder.getSellerPayoutAmount();
        this.price = builder.getPrice();
        this.volume = builder.getVolume();
        this.arbitratorNodeAddress = builder.getArbitratorNodeAddress();
        this.tradePeerNodeAddress = builder.getTradePeerNodeAddress();
        this.state = builder.getState();
        this.phase = builder.getPhase();
        this.periodState = builder.getPeriodState();
        this.payoutState = builder.getPayoutState();
        this.disputeState = builder.getDisputeState();
        this.isDepositsPublished = builder.isDepositsPublished();
        this.isDepositsConfirmed = builder.isDepositsConfirmed();
        this.isDepositsUnlocked = builder.isDepositsUnlocked();
        this.isPaymentSent = builder.isPaymentSent();
        this.isPaymentReceived = builder.isPaymentReceived();
        this.isPayoutPublished = builder.isPayoutPublished();
        this.isPayoutConfirmed = builder.isPayoutConfirmed();
        this.isPayoutUnlocked = builder.isPayoutUnlocked();
        this.isCompleted = builder.isCompleted();
        this.contractAsJson = builder.getContractAsJson();
        this.contract = builder.getContract();
    }

    public static TradeInfo toTradeInfo(Trade trade) {
        ContractInfo contractInfo;
        String role = TradeUtil.getRole(trade);
        if (trade.getContract() != null) {
            Contract contract = trade.getContract();
            contractInfo = new ContractInfo(contract.getBuyerPayoutAddressString(), contract.getSellerPayoutAddressString(), contract.getArbitratorNodeAddress().getFullAddress(), contract.isBuyerMakerAndSellerTaker(), contract.getMakerAccountId(), contract.getTakerAccountId(), trade.getMaker().getPaymentAccountPayload(), trade.getTaker().getPaymentAccountPayload(), contract.getMakerPayoutAddressString(), contract.getTakerPayoutAddressString());
        } else {
            contractInfo = ContractInfo.emptyContract.get();
        }
        return new TradeInfoV1Builder().withTradeId(trade.getId()).withShortId(trade.getShortId()).withDate(trade.getDate().getTime()).withRole(role == null ? "" : role).withMakerDepositTxId(trade.getMaker().getDepositTxHash()).withTakerDepositTxId(trade.getTaker().getDepositTxHash()).withPayoutTxId(trade.getPayoutTxId()).withAmount(trade.getAmount().longValueExact()).withMakerFee(trade.getMakerFee().longValueExact()).withTakerFee(trade.getTakerFee().longValueExact()).withBuyerSecurityDeposit(trade.getBuyer().getSecurityDeposit().longValueExact()).withSellerSecurityDeposit(trade.getSeller().getSecurityDeposit().longValueExact()).withBuyerDepositTxFee(trade.getBuyer().getDepositTxFee().longValueExact()).withSellerDepositTxFee(trade.getSeller().getDepositTxFee().longValueExact()).withBuyerPayoutTxFee(trade.getBuyer().getPayoutTxFee().longValueExact()).withSellerPayoutTxFee(trade.getSeller().getPayoutTxFee().longValueExact()).withBuyerPayoutAmount(trade.getBuyer().getPayoutAmount().longValueExact()).withSellerPayoutAmount(trade.getSeller().getPayoutAmount().longValueExact()).withTotalTxFee(trade.getTotalTxFee().longValueExact()).withPrice(toPreciseTradePrice.apply(trade)).withVolume(toRoundedVolume.apply(trade)).withArbitratorNodeAddress(toArbitratorNodeAddress.apply(trade)).withTradePeerNodeAddress(toPeerNodeAddress.apply(trade)).withState(trade.getState().name()).withPhase(trade.getPhase().name()).withPeriodState(trade.getPeriodState().name()).withPayoutState(trade.getPayoutState().name()).withDisputeState(trade.getDisputeState().name()).withIsDepositsPublished(trade.isDepositsPublished()).withIsDepositsConfirmed(trade.isDepositsConfirmed()).withIsDepositsUnlocked(trade.isDepositsUnlocked()).withIsPaymentSent(trade.isPaymentSent()).withIsPaymentReceived(trade.isPaymentReceived()).withIsPayoutPublished(trade.isPayoutPublished()).withIsPayoutConfirmed(trade.isPayoutConfirmed()).withIsPayoutUnlocked(trade.isPayoutUnlocked()).withIsCompleted(trade.isCompleted()).withContractAsJson(trade.getContractAsJson()).withContract(contractInfo).withOffer(OfferInfo.toOfferInfo(trade.getOffer())).build();
    }

    @Override
    public haveno.proto.grpc.TradeInfo toProtoMessage() {
        return haveno.proto.grpc.TradeInfo.newBuilder().setOffer(this.offer.toProtoMessage()).setTradeId(this.tradeId).setShortId(this.shortId).setDate(this.date).setRole(this.role).setMakerDepositTxId(this.makerDepositTxId == null ? "" : this.makerDepositTxId).setTakerDepositTxId(this.takerDepositTxId == null ? "" : this.takerDepositTxId).setPayoutTxId(this.payoutTxId == null ? "" : this.payoutTxId).setAmount(this.amount).setMakerFee(this.makerFee).setTakerFee(this.takerFee).setBuyerSecurityDeposit(this.buyerSecurityDeposit).setSellerSecurityDeposit(this.sellerSecurityDeposit).setBuyerDepositTxFee(this.buyerDepositTxFee).setSellerDepositTxFee(this.sellerDepositTxFee).setBuyerPayoutTxFee(this.buyerPayoutTxFee).setSellerPayoutTxFee(this.sellerPayoutTxFee).setBuyerPayoutAmount(this.buyerPayoutAmount).setSellerPayoutAmount(this.sellerPayoutAmount).setPrice(this.price).setTradeVolume(this.volume).setArbitratorNodeAddress(this.arbitratorNodeAddress).setTradePeerNodeAddress(this.tradePeerNodeAddress).setState(this.state).setPhase(this.phase).setPeriodState(this.periodState).setPayoutState(this.payoutState).setDisputeState(this.disputeState).setIsDepositsPublished(this.isDepositsPublished).setIsDepositsConfirmed(this.isDepositsConfirmed).setIsDepositsUnlocked(this.isDepositsUnlocked).setIsPaymentSent(this.isPaymentSent).setIsPaymentReceived(this.isPaymentReceived).setIsCompleted(this.isCompleted).setIsPayoutPublished(this.isPayoutPublished).setIsPayoutConfirmed(this.isPayoutConfirmed).setIsPayoutUnlocked(this.isPayoutUnlocked).setContractAsJson(this.contractAsJson == null ? "" : this.contractAsJson).setContract(this.contract.toProtoMessage()).build();
    }

    public static TradeInfo fromProto(haveno.proto.grpc.TradeInfo proto) {
        return new TradeInfoV1Builder().withOffer(OfferInfo.fromProto(proto.getOffer())).withTradeId(proto.getTradeId()).withShortId(proto.getShortId()).withDate(proto.getDate()).withRole(proto.getRole()).withMakerDepositTxId(proto.getMakerDepositTxId()).withTakerDepositTxId(proto.getTakerDepositTxId()).withPayoutTxId(proto.getPayoutTxId()).withAmount(proto.getAmount()).withMakerFee(proto.getMakerFee()).withTakerFee(proto.getTakerFee()).withBuyerSecurityDeposit(proto.getBuyerSecurityDeposit()).withSellerSecurityDeposit(proto.getSellerSecurityDeposit()).withBuyerDepositTxFee(proto.getBuyerDepositTxFee()).withSellerDepositTxFee(proto.getSellerDepositTxFee()).withBuyerPayoutTxFee(proto.getBuyerPayoutTxFee()).withSellerPayoutTxFee(proto.getSellerPayoutTxFee()).withBuyerPayoutAmount(proto.getBuyerPayoutAmount()).withSellerPayoutAmount(proto.getSellerPayoutAmount()).withPrice(proto.getPrice()).withVolume(proto.getTradeVolume()).withPeriodState(proto.getPeriodState()).withPayoutState(proto.getPayoutState()).withDisputeState(proto.getDisputeState()).withState(proto.getState()).withPhase(proto.getPhase()).withArbitratorNodeAddress(proto.getArbitratorNodeAddress()).withTradePeerNodeAddress(proto.getTradePeerNodeAddress()).withIsDepositsPublished(proto.getIsDepositsPublished()).withIsDepositsConfirmed(proto.getIsDepositsConfirmed()).withIsDepositsUnlocked(proto.getIsDepositsUnlocked()).withIsPaymentSent(proto.getIsPaymentSent()).withIsPaymentReceived(proto.getIsPaymentReceived()).withIsCompleted(proto.getIsCompleted()).withIsPayoutPublished(proto.getIsPayoutPublished()).withIsPayoutConfirmed(proto.getIsPayoutConfirmed()).withIsPayoutUnlocked(proto.getIsPayoutUnlocked()).withContractAsJson(proto.getContractAsJson()).withContract(ContractInfo.fromProto(proto.getContract())).build();
    }

    public String toString() {
        return "TradeInfo{  tradeId='" + this.tradeId + "'\n, shortId='" + this.shortId + "'\n, date='" + this.date + "'\n, role='" + this.role + "'\n, makerDepositTxId='" + this.makerDepositTxId + "'\n, takerDepositTxId='" + this.takerDepositTxId + "'\n, payoutTxId='" + this.payoutTxId + "'\n, amount='" + this.amount + "'\n, makerFee='" + this.makerFee + "'\n, takerFee='" + this.takerFee + "'\n, buyerSecurityDeposit='" + this.buyerSecurityDeposit + "'\n, sellerSecurityDeposit='" + this.sellerSecurityDeposit + "'\n, buyerDepositTxFee='" + this.buyerDepositTxFee + "'\n, sellerDepositTxFee='" + this.sellerDepositTxFee + "'\n, buyerPayoutTxFee='" + this.buyerPayoutTxFee + "'\n, sellerPayoutTxFee='" + this.sellerPayoutTxFee + "'\n, buyerPayoutAmount='" + this.buyerPayoutAmount + "'\n, sellerPayoutAmount='" + this.sellerPayoutAmount + "'\n, price='" + this.price + "'\n, arbitratorNodeAddress='" + this.arbitratorNodeAddress + "'\n, tradePeerNodeAddress='" + this.tradePeerNodeAddress + "'\n, state='" + this.state + "'\n, phase='" + this.phase + "'\n, periodState='" + this.periodState + "'\n, payoutState='" + this.payoutState + "'\n, disputeState='" + this.disputeState + "'\n, isDepositsPublished=" + this.isDepositsPublished + "\n, isDepositsConfirmed=" + this.isDepositsConfirmed + "\n, isDepositsUnlocked=" + this.isDepositsUnlocked + "\n, isPaymentSent=" + this.isPaymentSent + "\n, isPaymentReceived=" + this.isPaymentReceived + "\n, isPayoutPublished=" + this.isPayoutPublished + "\n, isPayoutConfirmed=" + this.isPayoutConfirmed + "\n, isPayoutUnlocked=" + this.isPayoutUnlocked + "\n, isCompleted=" + this.isCompleted + "\n, offer=" + String.valueOf(this.offer) + "\n, contractAsJson=" + this.contractAsJson + "\n, contract=" + String.valueOf(this.contract) + "\n}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TradeInfo)) {
            return false;
        }
        TradeInfo other = (TradeInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDate() != other.getDate()) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        if (this.getMakerFee() != other.getMakerFee()) {
            return false;
        }
        if (this.getTakerFee() != other.getTakerFee()) {
            return false;
        }
        if (this.getBuyerSecurityDeposit() != other.getBuyerSecurityDeposit()) {
            return false;
        }
        if (this.getSellerSecurityDeposit() != other.getSellerSecurityDeposit()) {
            return false;
        }
        if (this.getBuyerDepositTxFee() != other.getBuyerDepositTxFee()) {
            return false;
        }
        if (this.getSellerDepositTxFee() != other.getSellerDepositTxFee()) {
            return false;
        }
        if (this.getBuyerPayoutTxFee() != other.getBuyerPayoutTxFee()) {
            return false;
        }
        if (this.getSellerPayoutTxFee() != other.getSellerPayoutTxFee()) {
            return false;
        }
        if (this.getBuyerPayoutAmount() != other.getBuyerPayoutAmount()) {
            return false;
        }
        if (this.getSellerPayoutAmount() != other.getSellerPayoutAmount()) {
            return false;
        }
        if (this.isDepositsPublished() != other.isDepositsPublished()) {
            return false;
        }
        if (this.isDepositsConfirmed() != other.isDepositsConfirmed()) {
            return false;
        }
        if (this.isDepositsUnlocked() != other.isDepositsUnlocked()) {
            return false;
        }
        if (this.isPaymentSent() != other.isPaymentSent()) {
            return false;
        }
        if (this.isPaymentReceived() != other.isPaymentReceived()) {
            return false;
        }
        if (this.isPayoutPublished() != other.isPayoutPublished()) {
            return false;
        }
        if (this.isPayoutConfirmed() != other.isPayoutConfirmed()) {
            return false;
        }
        if (this.isPayoutUnlocked() != other.isPayoutUnlocked()) {
            return false;
        }
        if (this.isCompleted() != other.isCompleted()) {
            return false;
        }
        OfferInfo this$offer = this.getOffer();
        OfferInfo other$offer = other.getOffer();
        if (this$offer == null ? other$offer != null : !((Object)this$offer).equals(other$offer)) {
            return false;
        }
        String this$tradeId = this.getTradeId();
        String other$tradeId = other.getTradeId();
        if (this$tradeId == null ? other$tradeId != null : !this$tradeId.equals(other$tradeId)) {
            return false;
        }
        String this$shortId = this.getShortId();
        String other$shortId = other.getShortId();
        if (this$shortId == null ? other$shortId != null : !this$shortId.equals(other$shortId)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$makerDepositTxId = this.getMakerDepositTxId();
        String other$makerDepositTxId = other.getMakerDepositTxId();
        if (this$makerDepositTxId == null ? other$makerDepositTxId != null : !this$makerDepositTxId.equals(other$makerDepositTxId)) {
            return false;
        }
        String this$takerDepositTxId = this.getTakerDepositTxId();
        String other$takerDepositTxId = other.getTakerDepositTxId();
        if (this$takerDepositTxId == null ? other$takerDepositTxId != null : !this$takerDepositTxId.equals(other$takerDepositTxId)) {
            return false;
        }
        String this$payoutTxId = this.getPayoutTxId();
        String other$payoutTxId = other.getPayoutTxId();
        if (this$payoutTxId == null ? other$payoutTxId != null : !this$payoutTxId.equals(other$payoutTxId)) {
            return false;
        }
        String this$price = this.getPrice();
        String other$price = other.getPrice();
        if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
            return false;
        }
        String this$volume = this.getVolume();
        String other$volume = other.getVolume();
        if (this$volume == null ? other$volume != null : !this$volume.equals(other$volume)) {
            return false;
        }
        String this$arbitratorNodeAddress = this.getArbitratorNodeAddress();
        String other$arbitratorNodeAddress = other.getArbitratorNodeAddress();
        if (this$arbitratorNodeAddress == null ? other$arbitratorNodeAddress != null : !this$arbitratorNodeAddress.equals(other$arbitratorNodeAddress)) {
            return false;
        }
        String this$tradePeerNodeAddress = this.getTradePeerNodeAddress();
        String other$tradePeerNodeAddress = other.getTradePeerNodeAddress();
        if (this$tradePeerNodeAddress == null ? other$tradePeerNodeAddress != null : !this$tradePeerNodeAddress.equals(other$tradePeerNodeAddress)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$phase = this.getPhase();
        String other$phase = other.getPhase();
        if (this$phase == null ? other$phase != null : !this$phase.equals(other$phase)) {
            return false;
        }
        String this$periodState = this.getPeriodState();
        String other$periodState = other.getPeriodState();
        if (this$periodState == null ? other$periodState != null : !this$periodState.equals(other$periodState)) {
            return false;
        }
        String this$payoutState = this.getPayoutState();
        String other$payoutState = other.getPayoutState();
        if (this$payoutState == null ? other$payoutState != null : !this$payoutState.equals(other$payoutState)) {
            return false;
        }
        String this$disputeState = this.getDisputeState();
        String other$disputeState = other.getDisputeState();
        if (this$disputeState == null ? other$disputeState != null : !this$disputeState.equals(other$disputeState)) {
            return false;
        }
        String this$contractAsJson = this.getContractAsJson();
        String other$contractAsJson = other.getContractAsJson();
        if (this$contractAsJson == null ? other$contractAsJson != null : !this$contractAsJson.equals(other$contractAsJson)) {
            return false;
        }
        ContractInfo this$contract = this.getContract();
        ContractInfo other$contract = other.getContract();
        return !(this$contract == null ? other$contract != null : !this$contract.equals(other$contract));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TradeInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $date = this.getDate();
        result = result * 59 + (int)($date >>> 32 ^ $date);
        long $amount = this.getAmount();
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        long $makerFee = this.getMakerFee();
        result = result * 59 + (int)($makerFee >>> 32 ^ $makerFee);
        long $takerFee = this.getTakerFee();
        result = result * 59 + (int)($takerFee >>> 32 ^ $takerFee);
        long $buyerSecurityDeposit = this.getBuyerSecurityDeposit();
        result = result * 59 + (int)($buyerSecurityDeposit >>> 32 ^ $buyerSecurityDeposit);
        long $sellerSecurityDeposit = this.getSellerSecurityDeposit();
        result = result * 59 + (int)($sellerSecurityDeposit >>> 32 ^ $sellerSecurityDeposit);
        long $buyerDepositTxFee = this.getBuyerDepositTxFee();
        result = result * 59 + (int)($buyerDepositTxFee >>> 32 ^ $buyerDepositTxFee);
        long $sellerDepositTxFee = this.getSellerDepositTxFee();
        result = result * 59 + (int)($sellerDepositTxFee >>> 32 ^ $sellerDepositTxFee);
        long $buyerPayoutTxFee = this.getBuyerPayoutTxFee();
        result = result * 59 + (int)($buyerPayoutTxFee >>> 32 ^ $buyerPayoutTxFee);
        long $sellerPayoutTxFee = this.getSellerPayoutTxFee();
        result = result * 59 + (int)($sellerPayoutTxFee >>> 32 ^ $sellerPayoutTxFee);
        long $buyerPayoutAmount = this.getBuyerPayoutAmount();
        result = result * 59 + (int)($buyerPayoutAmount >>> 32 ^ $buyerPayoutAmount);
        long $sellerPayoutAmount = this.getSellerPayoutAmount();
        result = result * 59 + (int)($sellerPayoutAmount >>> 32 ^ $sellerPayoutAmount);
        result = result * 59 + (this.isDepositsPublished() ? 79 : 97);
        result = result * 59 + (this.isDepositsConfirmed() ? 79 : 97);
        result = result * 59 + (this.isDepositsUnlocked() ? 79 : 97);
        result = result * 59 + (this.isPaymentSent() ? 79 : 97);
        result = result * 59 + (this.isPaymentReceived() ? 79 : 97);
        result = result * 59 + (this.isPayoutPublished() ? 79 : 97);
        result = result * 59 + (this.isPayoutConfirmed() ? 79 : 97);
        result = result * 59 + (this.isPayoutUnlocked() ? 79 : 97);
        result = result * 59 + (this.isCompleted() ? 79 : 97);
        OfferInfo $offer = this.getOffer();
        result = result * 59 + ($offer == null ? 43 : ((Object)$offer).hashCode());
        String $tradeId = this.getTradeId();
        result = result * 59 + ($tradeId == null ? 43 : $tradeId.hashCode());
        String $shortId = this.getShortId();
        result = result * 59 + ($shortId == null ? 43 : $shortId.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $makerDepositTxId = this.getMakerDepositTxId();
        result = result * 59 + ($makerDepositTxId == null ? 43 : $makerDepositTxId.hashCode());
        String $takerDepositTxId = this.getTakerDepositTxId();
        result = result * 59 + ($takerDepositTxId == null ? 43 : $takerDepositTxId.hashCode());
        String $payoutTxId = this.getPayoutTxId();
        result = result * 59 + ($payoutTxId == null ? 43 : $payoutTxId.hashCode());
        String $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : $price.hashCode());
        String $volume = this.getVolume();
        result = result * 59 + ($volume == null ? 43 : $volume.hashCode());
        String $arbitratorNodeAddress = this.getArbitratorNodeAddress();
        result = result * 59 + ($arbitratorNodeAddress == null ? 43 : $arbitratorNodeAddress.hashCode());
        String $tradePeerNodeAddress = this.getTradePeerNodeAddress();
        result = result * 59 + ($tradePeerNodeAddress == null ? 43 : $tradePeerNodeAddress.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $phase = this.getPhase();
        result = result * 59 + ($phase == null ? 43 : $phase.hashCode());
        String $periodState = this.getPeriodState();
        result = result * 59 + ($periodState == null ? 43 : $periodState.hashCode());
        String $payoutState = this.getPayoutState();
        result = result * 59 + ($payoutState == null ? 43 : $payoutState.hashCode());
        String $disputeState = this.getDisputeState();
        result = result * 59 + ($disputeState == null ? 43 : $disputeState.hashCode());
        String $contractAsJson = this.getContractAsJson();
        result = result * 59 + ($contractAsJson == null ? 43 : $contractAsJson.hashCode());
        ContractInfo $contract = this.getContract();
        result = result * 59 + ($contract == null ? 43 : $contract.hashCode());
        return result;
    }

    public OfferInfo getOffer() {
        return this.offer;
    }

    public String getTradeId() {
        return this.tradeId;
    }

    public String getShortId() {
        return this.shortId;
    }

    public long getDate() {
        return this.date;
    }

    public String getRole() {
        return this.role;
    }

    public String getMakerDepositTxId() {
        return this.makerDepositTxId;
    }

    public String getTakerDepositTxId() {
        return this.takerDepositTxId;
    }

    public String getPayoutTxId() {
        return this.payoutTxId;
    }

    public long getAmount() {
        return this.amount;
    }

    public long getMakerFee() {
        return this.makerFee;
    }

    public long getTakerFee() {
        return this.takerFee;
    }

    public long getBuyerSecurityDeposit() {
        return this.buyerSecurityDeposit;
    }

    public long getSellerSecurityDeposit() {
        return this.sellerSecurityDeposit;
    }

    public long getBuyerDepositTxFee() {
        return this.buyerDepositTxFee;
    }

    public long getSellerDepositTxFee() {
        return this.sellerDepositTxFee;
    }

    public long getBuyerPayoutTxFee() {
        return this.buyerPayoutTxFee;
    }

    public long getSellerPayoutTxFee() {
        return this.sellerPayoutTxFee;
    }

    public long getBuyerPayoutAmount() {
        return this.buyerPayoutAmount;
    }

    public long getSellerPayoutAmount() {
        return this.sellerPayoutAmount;
    }

    public String getPrice() {
        return this.price;
    }

    public String getVolume() {
        return this.volume;
    }

    public String getArbitratorNodeAddress() {
        return this.arbitratorNodeAddress;
    }

    public String getTradePeerNodeAddress() {
        return this.tradePeerNodeAddress;
    }

    public String getState() {
        return this.state;
    }

    public String getPhase() {
        return this.phase;
    }

    public String getPeriodState() {
        return this.periodState;
    }

    public String getPayoutState() {
        return this.payoutState;
    }

    public String getDisputeState() {
        return this.disputeState;
    }

    public boolean isDepositsPublished() {
        return this.isDepositsPublished;
    }

    public boolean isDepositsConfirmed() {
        return this.isDepositsConfirmed;
    }

    public boolean isDepositsUnlocked() {
        return this.isDepositsUnlocked;
    }

    public boolean isPaymentSent() {
        return this.isPaymentSent;
    }

    public boolean isPaymentReceived() {
        return this.isPaymentReceived;
    }

    public boolean isPayoutPublished() {
        return this.isPayoutPublished;
    }

    public boolean isPayoutConfirmed() {
        return this.isPayoutConfirmed;
    }

    public boolean isPayoutUnlocked() {
        return this.isPayoutUnlocked;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public String getContractAsJson() {
        return this.contractAsJson;
    }

    public ContractInfo getContract() {
        return this.contract;
    }
}

