/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api.model;

import com.google.common.annotations.VisibleForTesting;
import haveno.common.Payload;
import java.math.BigInteger;

public class XmrBalanceInfo
implements Payload {
    public static final XmrBalanceInfo EMPTY = new XmrBalanceInfo(-1L, -1L, -1L, -1L, -1L);
    private final long balance;
    private final long availableBalance;
    private final long pendingBalance;
    private final long reservedOfferBalance;
    private final long reservedTradeBalance;
    private final long reservedBalance;

    public XmrBalanceInfo(long balance, long unlockedBalance, long pendingBalance, long reservedOfferBalance, long reservedTradeBalance) {
        this.balance = balance;
        this.availableBalance = unlockedBalance;
        this.pendingBalance = pendingBalance;
        this.reservedOfferBalance = reservedOfferBalance;
        this.reservedTradeBalance = reservedTradeBalance;
        this.reservedBalance = reservedOfferBalance + reservedTradeBalance;
    }

    @VisibleForTesting
    public static XmrBalanceInfo valueOf(long balance, long availableBalance, long pendingBalance, long reservedOfferBalance, long reservedTradeBalance) {
        return new XmrBalanceInfo(balance, availableBalance, pendingBalance, reservedOfferBalance, reservedTradeBalance);
    }

    public BigInteger getBalance() {
        return BigInteger.valueOf(this.balance);
    }

    public BigInteger getAvailableBalance() {
        return BigInteger.valueOf(this.availableBalance);
    }

    public BigInteger getPendingBalance() {
        return BigInteger.valueOf(this.pendingBalance);
    }

    public BigInteger getReservedOfferBalance() {
        return BigInteger.valueOf(this.reservedOfferBalance);
    }

    public BigInteger getReservedTradeBalance() {
        return BigInteger.valueOf(this.reservedTradeBalance);
    }

    public BigInteger getReservedBalance() {
        return BigInteger.valueOf(this.reservedBalance);
    }

    @Override
    public haveno.proto.grpc.XmrBalanceInfo toProtoMessage() {
        return haveno.proto.grpc.XmrBalanceInfo.newBuilder().setBalance(this.balance).setAvailableBalance(this.availableBalance).setPendingBalance(this.pendingBalance).setReservedOfferBalance(this.reservedOfferBalance).setReservedTradeBalance(this.reservedTradeBalance).build();
    }

    public static XmrBalanceInfo fromProto(haveno.proto.grpc.XmrBalanceInfo proto) {
        return new XmrBalanceInfo(proto.getBalance(), proto.getAvailableBalance(), proto.getPendingBalance(), proto.getReservedOfferBalance(), proto.getReservedTradeBalance());
    }

    public String toString() {
        return "XmrBalanceInfo{balance=" + this.balance + ", unlockedBalance=" + this.availableBalance + ", lockedBalance=" + this.pendingBalance + ", reservedOfferBalance=" + this.reservedOfferBalance + ", reservedTradeBalance=" + this.reservedTradeBalance + "}";
    }
}

