/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api.model;

import haveno.common.Payload;
import java.math.BigInteger;
import monero.wallet.model.MoneroIncomingTransfer;

public class XmrIncomingTransfer
implements Payload {
    private final BigInteger amount;
    private final Integer accountIndex;
    private final Integer subaddressIndex;
    private final String address;
    private final Long numSuggestedConfirmations;

    public XmrIncomingTransfer(XmrIncomingTransferBuilder builder) {
        this.amount = builder.amount;
        this.accountIndex = builder.accountIndex;
        this.subaddressIndex = builder.subaddressIndex;
        this.address = builder.address;
        this.numSuggestedConfirmations = builder.numSuggestedConfirmations;
    }

    public static XmrIncomingTransfer toXmrIncomingTransfer(MoneroIncomingTransfer transfer) {
        return new XmrIncomingTransferBuilder().withAmount(transfer.getAmount()).withAccountIndex(transfer.getAccountIndex()).withSubaddressIndex(transfer.getSubaddressIndex()).withAddress(transfer.getAddress()).withNumSuggestedConfirmations(transfer.getNumSuggestedConfirmations()).build();
    }

    @Override
    public haveno.proto.grpc.XmrIncomingTransfer toProtoMessage() {
        return haveno.proto.grpc.XmrIncomingTransfer.newBuilder().setAmount(this.amount.toString()).setAccountIndex(this.accountIndex).setSubaddressIndex(this.subaddressIndex).setAddress(this.address).setNumSuggestedConfirmations(this.numSuggestedConfirmations).build();
    }

    public static XmrIncomingTransfer fromProto(haveno.proto.grpc.XmrIncomingTransfer proto) {
        return new XmrIncomingTransferBuilder().withAmount(new BigInteger(proto.getAmount())).withAccountIndex(proto.getAccountIndex()).withSubaddressIndex(proto.getSubaddressIndex()).withAddress(proto.getAddress()).withNumSuggestedConfirmations(proto.getNumSuggestedConfirmations()).build();
    }

    public String toString() {
        return "XmrIncomingTransfer{amount=" + String.valueOf(this.amount) + ", accountIndex=" + this.accountIndex + ", subaddressIndex=" + this.subaddressIndex + ", address=" + this.address + ", numSuggestedConfirmations=" + this.numSuggestedConfirmations + "}";
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public Integer getAccountIndex() {
        return this.accountIndex;
    }

    public Integer getSubaddressIndex() {
        return this.subaddressIndex;
    }

    public String getAddress() {
        return this.address;
    }

    public Long getNumSuggestedConfirmations() {
        return this.numSuggestedConfirmations;
    }

    public static class XmrIncomingTransferBuilder {
        private BigInteger amount;
        private Integer accountIndex;
        private Integer subaddressIndex;
        private String address;
        private Long numSuggestedConfirmations;

        public XmrIncomingTransferBuilder withAmount(BigInteger amount) {
            this.amount = amount;
            return this;
        }

        public XmrIncomingTransferBuilder withAccountIndex(Integer accountIndex) {
            this.accountIndex = accountIndex;
            return this;
        }

        public XmrIncomingTransferBuilder withSubaddressIndex(Integer subaddressIndex) {
            this.subaddressIndex = subaddressIndex;
            return this;
        }

        public XmrIncomingTransferBuilder withAddress(String address) {
            this.address = address;
            return this;
        }

        public XmrIncomingTransferBuilder withNumSuggestedConfirmations(Long numSuggestedConfirmations) {
            this.numSuggestedConfirmations = numSuggestedConfirmations;
            return this;
        }

        public XmrIncomingTransfer build() {
            return new XmrIncomingTransfer(this);
        }
    }
}

