/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api.model;

import haveno.common.Payload;
import haveno.common.proto.ProtoUtil;
import haveno.core.api.model.XmrDestination;
import haveno.proto.grpc.XmrOutgoingTransfer;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import monero.wallet.model.MoneroOutgoingTransfer;

public class XmrOutgoingTransfer
implements Payload {
    private final BigInteger amount;
    private final Integer accountIndex;
    @Nullable
    private final List<Integer> subaddressIndices;
    @Nullable
    private final List<XmrDestination> destinations;

    public XmrOutgoingTransfer(XmrOutgoingTransferBuilder builder) {
        this.amount = builder.amount;
        this.accountIndex = builder.accountIndex;
        this.subaddressIndices = builder.subaddressIndices;
        this.destinations = builder.destinations;
    }

    public static XmrOutgoingTransfer toXmrOutgoingTransfer(MoneroOutgoingTransfer transfer) {
        List<XmrDestination> destinations = transfer.getDestinations() == null ? null : transfer.getDestinations().stream().map(s2 -> XmrDestination.toXmrDestination(s2)).collect(Collectors.toList());
        XmrOutgoingTransferBuilder builder = new XmrOutgoingTransferBuilder().withAmount(transfer.getAmount()).withAccountIndex(transfer.getAccountIndex()).withSubaddressIndices(transfer.getSubaddressIndices()).withDestinations(destinations);
        return builder.build();
    }

    @Override
    public haveno.proto.grpc.XmrOutgoingTransfer toProtoMessage() {
        XmrOutgoingTransfer.Builder builder = haveno.proto.grpc.XmrOutgoingTransfer.newBuilder().setAmount(this.amount.toString()).setAccountIndex(this.accountIndex);
        Optional.ofNullable(this.subaddressIndices).ifPresent(e -> builder.addAllSubaddressIndices(this.subaddressIndices));
        Optional.ofNullable(this.destinations).ifPresent(e -> builder.addAllDestinations(ProtoUtil.collectionToProto(this.destinations, haveno.proto.grpc.XmrDestination.class)));
        return builder.build();
    }

    public static XmrOutgoingTransfer fromProto(haveno.proto.grpc.XmrOutgoingTransfer proto) {
        List<XmrDestination> destinations = proto.getDestinationsList().isEmpty() ? null : proto.getDestinationsList().stream().map(XmrDestination::fromProto).collect(Collectors.toList());
        return new XmrOutgoingTransferBuilder().withAmount(new BigInteger(proto.getAmount())).withAccountIndex(proto.getAccountIndex()).withSubaddressIndices(proto.getSubaddressIndicesList()).withDestinations(destinations).build();
    }

    public String toString() {
        return "XmrOutgoingTransfer{amount=" + String.valueOf(this.amount) + ", accountIndex=" + this.accountIndex + ", subaddressIndices=" + String.valueOf(this.subaddressIndices) + ", destinations=" + String.valueOf(this.destinations) + "}";
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public Integer getAccountIndex() {
        return this.accountIndex;
    }

    @Nullable
    public List<Integer> getSubaddressIndices() {
        return this.subaddressIndices;
    }

    @Nullable
    public List<XmrDestination> getDestinations() {
        return this.destinations;
    }

    public static class XmrOutgoingTransferBuilder {
        private BigInteger amount;
        private Integer accountIndex;
        private List<Integer> subaddressIndices;
        private List<XmrDestination> destinations;

        public XmrOutgoingTransferBuilder withAmount(BigInteger amount) {
            this.amount = amount;
            return this;
        }

        public XmrOutgoingTransferBuilder withAccountIndex(Integer accountIndex) {
            this.accountIndex = accountIndex;
            return this;
        }

        public XmrOutgoingTransferBuilder withSubaddressIndices(List<Integer> subaddressIndices) {
            this.subaddressIndices = subaddressIndices;
            return this;
        }

        public XmrOutgoingTransferBuilder withDestinations(List<XmrDestination> destinations) {
            this.destinations = destinations;
            return this;
        }

        public XmrOutgoingTransfer build() {
            return new XmrOutgoingTransfer(this);
        }
    }
}

