/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.config.Config;
import haveno.common.file.FileUtil;
import haveno.common.file.ResourceNotFoundException;
import haveno.common.util.Utilities;
import haveno.core.user.Preferences;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AvoidStandbyModeService {
    private static final Logger log = LoggerFactory.getLogger(AvoidStandbyModeService.class);
    private final Preferences preferences;
    private final Config config;
    private final Optional<String> inhibitorPathSpec;
    private CountDownLatch stopLinuxInhibitorCountdownLatch;
    private volatile boolean isStopped;
    private final Predicate<String> isCmdInstalled = p -> {
        File executable = Paths.get(p, new String[0]).toFile();
        return executable.exists() && executable.canExecute();
    };
    private final Function<String[], Optional<String>> cmdPath = possiblePaths -> {
        for (String path : possiblePaths) {
            if (!this.isCmdInstalled.test(path)) continue;
            return Optional.of(path);
        }
        return Optional.empty();
    };
    private final Supplier<List<Optional<String>>> installedInhibitors = () -> new ArrayList<Optional<String>>(){
        {
            this.add(AvoidStandbyModeService.this.gnomeSessionInhibitPathSpec.get());
            this.add(AvoidStandbyModeService.this.systemdInhibitPathSpec.get());
        }
    };
    private final Supplier<Optional<String>> gnomeSessionInhibitPathSpec = () -> this.cmdPath.apply(new String[]{"/usr/bin/gnome-session-inhibit", "/bin/gnome-session-inhibit"});
    private final Supplier<Optional<String>> systemdInhibitPathSpec = () -> this.cmdPath.apply(new String[]{"/usr/bin/systemd-inhibit", "/bin/systemd-inhibit"});

    @Inject
    public AvoidStandbyModeService(Preferences preferences, Config config) {
        this.preferences = preferences;
        this.config = config;
        this.inhibitorPathSpec = this.inhibitorPath();
        preferences.getUseStandbyModeProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                if (Utilities.isLinux() && this.runningInhibitorProcess().isPresent()) {
                    Objects.requireNonNull(this.stopLinuxInhibitorCountdownLatch).countDown();
                }
            } else {
                this.start();
            }
        });
    }

    public void init() {
        this.isStopped = this.preferences.isUseStandbyMode();
        if (!this.isStopped) {
            this.start();
        }
    }

    private void start() {
        this.isStopped = false;
        if (Utilities.isLinux()) {
            this.startInhibitor();
        } else {
            new Thread(this::playSilentAudioFile, "AvoidStandbyModeService-thread").start();
        }
    }

    public void shutDown() {
        this.isStopped = true;
        this.stopInhibitor();
    }

    private void startInhibitor() {
        try {
            if (this.runningInhibitorProcess().isPresent()) {
                log.info("Inhibitor already started");
                return;
            }
            this.inhibitCommand().ifPresent(cmd -> {
                try {
                    new ProcessBuilder((String)cmd).start();
                    log.info("Started -- disabled power management via {}", (Object)String.join((CharSequence)" ", cmd));
                    if (Utilities.isLinux()) {
                        this.stopLinuxInhibitorCountdownLatch = new CountDownLatch(1);
                        new Thread(this::stopInhibitor, "StopAvoidStandbyModeService-thread").start();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            log.error("Cannot avoid standby mode", e);
        }
    }

    private void stopInhibitor() {
        try {
            if (Utilities.isLinux()) {
                if (!this.isStopped) {
                    Objects.requireNonNull(this.stopLinuxInhibitorCountdownLatch).await();
                }
                Optional<ProcessHandle> runningInhibitor = this.runningInhibitorProcess();
                runningInhibitor.ifPresent(processHandle -> {
                    processHandle.destroy();
                    log.info("Stopped");
                });
            }
        }
        catch (Exception e) {
            log.error("Stop inhibitor thread interrupted", e);
        }
    }

    private void playSilentAudioFile() {
        try {
            log.info("Started");
            while (!this.isStopped) {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(this.getSoundFile());
                try {
                    SourceDataLine sourceDataLine = this.getSourceDataLine(audioInputStream.getFormat());
                    try {
                        int cnt;
                        byte[] tempBuffer = new byte[10000];
                        sourceDataLine.open(audioInputStream.getFormat());
                        sourceDataLine.start();
                        while ((cnt = audioInputStream.read(tempBuffer, 0, tempBuffer.length)) != -1 && !this.isStopped) {
                            if (cnt <= 0) continue;
                            sourceDataLine.write(tempBuffer, 0, cnt);
                        }
                        sourceDataLine.drain();
                    }
                    finally {
                        if (sourceDataLine == null) continue;
                        sourceDataLine.close();
                    }
                }
                finally {
                    if (audioInputStream == null) continue;
                    audioInputStream.close();
                }
            }
        }
        catch (Exception e) {
            log.error(e.toString());
            e.printStackTrace();
        }
    }

    private File getSoundFile() throws IOException, ResourceNotFoundException {
        File soundFile = new File(this.config.appDataDir, "prevent-app-nap-silent-sound.aiff");
        if (!soundFile.exists() || soundFile.length() > 42000000L) {
            FileUtil.resourceToFile("prevent-app-nap-silent-sound.aiff", soundFile);
        }
        return soundFile;
    }

    private SourceDataLine getSourceDataLine(AudioFormat audioFormat) throws LineUnavailableException {
        DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, audioFormat);
        return (SourceDataLine)AudioSystem.getLine(dataLineInfo);
    }

    private Optional<String> inhibitorPath() {
        for (Optional<String> installedInhibitor : this.installedInhibitors.get()) {
            if (!installedInhibitor.isPresent()) continue;
            return installedInhibitor;
        }
        return Optional.empty();
    }

    private Optional<String[]> inhibitCommand() {
        String[] params;
        if (this.inhibitorPathSpec.isPresent()) {
            String cmd = this.inhibitorPathSpec.get();
            if (Utilities.isLinux()) {
                String[] stringArray;
                if (cmd.contains("gnome-session-inhibit")) {
                    String[] stringArray2 = new String[8];
                    stringArray2[0] = cmd;
                    stringArray2[1] = "--app-id";
                    stringArray2[2] = "Haveno";
                    stringArray2[3] = "--inhibit";
                    stringArray2[4] = "suspend";
                    stringArray2[5] = "--reason";
                    stringArray2[6] = "Avoid Standby";
                    stringArray = stringArray2;
                    stringArray2[7] = "--inhibit-only";
                } else {
                    String[] stringArray3 = new String[12];
                    stringArray3[0] = cmd;
                    stringArray3[1] = "--who";
                    stringArray3[2] = "Haveno";
                    stringArray3[3] = "--what";
                    stringArray3[4] = "sleep";
                    stringArray3[5] = "--why";
                    stringArray3[6] = "Avoid Standby";
                    stringArray3[7] = "--mode";
                    stringArray3[8] = "block";
                    stringArray3[9] = "tail";
                    stringArray3[10] = "-f";
                    stringArray = stringArray3;
                    stringArray3[11] = "/dev/null";
                }
                params = stringArray;
            } else {
                params = null;
            }
        } else {
            params = null;
        }
        return params == null ? Optional.empty() : Optional.of(params);
    }

    private Optional<ProcessHandle> runningInhibitorProcess() {
        ProcessHandle[] inhibitorProc = new ProcessHandle[1];
        this.inhibitorPathSpec.ifPresent(cmd -> {
            Optional<ProcessHandle> jvmProc = ProcessHandle.of(ProcessHandle.current().pid());
            jvmProc.ifPresent(proc -> proc.children().forEach(childProc -> childProc.info().command().ifPresent(command -> {
                if (command.equals(cmd) && childProc.isAlive()) {
                    inhibitorProc[0] = childProc;
                }
            })));
        });
        return inhibitorProc[0] == null ? Optional.empty() : Optional.of(inhibitorProc[0]);
    }
}

