/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app;

import com.google.inject.Singleton;
import com.google.inject.name.Names;
import haveno.common.app.AppModule;
import haveno.common.config.Config;
import haveno.common.proto.network.NetworkProtoResolver;
import haveno.common.proto.persistable.PersistenceProtoResolver;
import haveno.core.alert.AlertModule;
import haveno.core.filter.FilterModule;
import haveno.core.network.CoreBanFilter;
import haveno.core.network.p2p.seed.DefaultSeedNodeRepository;
import haveno.core.offer.OfferModule;
import haveno.core.presentation.CorePresentationModule;
import haveno.core.proto.network.CoreNetworkProtoResolver;
import haveno.core.proto.persistable.CorePersistenceProtoResolver;
import haveno.core.trade.TradeModule;
import haveno.core.user.Preferences;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.coin.ImmutableCoinFormatter;
import haveno.core.xmr.XmrConnectionModule;
import haveno.core.xmr.XmrModule;
import haveno.network.crypto.EncryptionServiceModule;
import haveno.network.p2p.P2PModule;
import haveno.network.p2p.network.BanFilter;
import haveno.network.p2p.network.BridgeAddressProvider;
import haveno.network.p2p.seed.SeedNodeRepository;
import java.io.File;

public class CoreModule
extends AppModule {
    public CoreModule(Config config) {
        super(config);
    }

    @Override
    protected void configure() {
        this.bind(Config.class).toInstance(this.config);
        this.bind(BridgeAddressProvider.class).to(Preferences.class);
        this.bind(SeedNodeRepository.class).to(DefaultSeedNodeRepository.class);
        this.bind(BanFilter.class).to(CoreBanFilter.class).in(Singleton.class);
        this.bind(File.class).annotatedWith(Names.named("storageDir")).toInstance(this.config.storageDir);
        ImmutableCoinFormatter btcFormatter = new ImmutableCoinFormatter(this.config.networkParameters.getMonetaryFormat());
        this.bind(CoinFormatter.class).annotatedWith(Names.named("BTC")).toInstance(btcFormatter);
        this.bind(File.class).annotatedWith(Names.named("keyStorageDir")).toInstance(this.config.keyStorageDir);
        this.bind(NetworkProtoResolver.class).to(CoreNetworkProtoResolver.class);
        this.bind(PersistenceProtoResolver.class).to(CorePersistenceProtoResolver.class);
        this.bindConstant().annotatedWith(Names.named("useDevPrivilegeKeys")).to(this.config.useDevPrivilegeKeys);
        this.bindConstant().annotatedWith(Names.named("useDevMode")).to(this.config.useDevMode);
        this.bindConstant().annotatedWith(Names.named("useDevModeHeader")).to(this.config.useDevModeHeader);
        this.bindConstant().annotatedWith(Names.named("referralId")).to(this.config.referralId);
        this.install(new TradeModule(this.config));
        this.install(new EncryptionServiceModule(this.config));
        this.install(new OfferModule(this.config));
        this.install(new P2PModule(this.config));
        this.install(new XmrModule(this.config));
        this.install(new AlertModule(this.config));
        this.install(new FilterModule(this.config));
        this.install(new CorePresentationModule(this.config));
        this.install(new XmrConnectionModule(this.config));
    }
}

